/*
 * Decompiled with CFR 0.152.
 */
package com.jsigle.noa;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.document.DocumentDescriptor;
import ag.ion.bion.officelayer.document.DocumentException;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import ag.ion.bion.officelayer.event.ICloseEvent;
import ag.ion.bion.officelayer.event.ICloseListener;
import ag.ion.bion.officelayer.event.IEvent;
import ag.ion.bion.officelayer.form.IFormComponent;
import ag.ion.bion.officelayer.form.IFormService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.table.ITextTablePropertyStore;
import ag.ion.bion.workbench.office.editor.core.EditorCorePlugin;
import ag.ion.noa.NOAException;
import ag.ion.noa.search.ISearchResult;
import ag.ion.noa.search.SearchDescriptor;
import ag.ion.noa4e.internal.ui.preferences.LocalOfficeApplicationPreferencesPage;
import ag.ion.noa4e.ui.widgets.OfficePanel;
import ch.elexis.Hub;
import ch.elexis.actions.ElexisEventDispatcher;
import ch.elexis.data.Patient;
import ch.elexis.text.ITextPlugin;
import ch.elexis.text.ReplaceCallback;
import ch.elexis.util.Log;
import ch.elexis.util.SWTHelper;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.jsigle.noa.OOPrinter;
import com.sun.star.awt.Size;
import com.sun.star.awt.XTextComponent;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.table.TableBorder;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.PrintableState;
import com.sun.star.view.XPrintJobBroadcaster;
import com.sun.star.view.XPrintJobListener;
import com.sun.star.view.XPrintable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class NOAText
implements ITextPlugin {
    public static final String MIMETYPE_OO2 = "application/vnd.oasis.opendocument.text";
    public static LinkedList<NOAText> noas = new LinkedList();
    OfficePanel panel;
    ITextDocument doc;
    ITextPlugin.ICallback textHandler;
    File myFile;
    private final Log log = Log.get((String)"NOAText");
    IOfficeApplication office;
    private String font;
    private float hi = 0.0f;
    private int stil = -1;

    public NOAText() {
        String defaultbase;
        System.out.println("NOAText: NOAText: noa loaded");
        System.out.println("NOAText: NOAText: computing defaultbase...");
        File base = new File(Hub.getBasePath());
        File fDef = new File(base.getParentFile().getParent() + "/ooo");
        System.out.println("NOAText: NOAText: Hub.getBasePath():" + Hub.getBasePath());
        System.out.println("NOAText: NOAText: base.getParentFile().getParent() + \"/ooo\":" + base.getParentFile().getParent() + "/ooo");
        if (fDef.exists()) {
            defaultbase = fDef.getAbsolutePath();
            Hub.localCfg.set("briefe/OOBasis", defaultbase);
        } else {
            defaultbase = Hub.localCfg.get("briefe/OOBasis", ".");
        }
        System.out.println("NOAText: NOAText: computed defaultbase=openoffice.path.name:" + defaultbase);
        System.setProperty("openoffice.path.name", defaultbase);
    }

    private void createMe() {
        System.out.println("NOAText: createMe");
        if (this.office == null) {
            System.out.println("NOAText: Please note: createMe: office==null");
            this.office = EditorCorePlugin.getDefault().getManagedLocalOfficeApplication();
        }
        if (this.office == null) {
            System.out.println("NOAText: createMe: WARNING: still, office==null");
        } else {
            System.out.println("NOAText: createMe: office=" + this.office.toString());
        }
        if (this.panel == null) {
            System.out.println("NOAText: createMe: WARNING: panel==null");
        } else {
            System.out.println("NOAText: createMe: panel=" + this.panel.toString());
        }
        this.doc = (ITextDocument)this.panel.getDocument();
        if (this.doc == null) {
            System.out.println("NOAText: createMe: WARNING: doc==null");
        } else {
            System.out.println("NOAText: createMe: doc=" + this.doc.toString());
        }
        if (this.doc != null) {
            System.out.println("NOAText: createMe: doc.addCloseListener()...");
            this.doc.addCloseListener(new closeListener(this.office));
            System.out.println("NOAText: createMe: noas.add(this)...");
            noas.add(this);
        }
        System.out.println("NOAText: createMe ends");
    }

    private void removeMe() {
        System.out.println("NOAText: removeMe begin");
        try {
            System.out.println("NOAText: removeMe: trying 1...");
            if (this.textHandler != null) {
                System.out.println("NOAText: removeMe: textHandler.save()...");
                this.textHandler.save();
                System.out.println("NOAText: removeMe: noas.remove(this)...");
                noas.remove(this);
                if (this.doc != null) {
                    this.doc.setModified(false);
                    System.out.println("NOAText: removeMe: doc.close()...");
                    this.doc.close();
                }
            }
        }
        catch (Exception ex) {
            System.out.println("NOAText: removeMe: WARNING: caught Exception");
            ExHandler.handle((Throwable)ex);
        }
        if (noas.isEmpty()) {
            System.out.println("NOAText: removeMe: noas.isEmpty()");
            try {
                System.out.println("NOAText: removeMe: trying office.deactivate()...");
                this.office.deactivate();
                this.log.log("Office deactivated", 4);
            }
            catch (OfficeApplicationException e) {
                System.out.println("NOAText: removeMe: WARNING: caught Exception");
                ExHandler.handle((Throwable)e);
                this.log.log("Office deactivation failed", 2);
            }
        }
        System.out.println("NOAText: removeMe end");
    }

    public boolean clear() {
        System.out.println("NOAText: clear begin");
        if (this.textHandler != null) {
            try {
                System.out.println("NOAText: clear: textHandler.save()...");
                this.textHandler.save();
                System.out.println("NOAText: clear: doc.setModified(false);");
                this.doc.setModified(false);
                System.out.println("NOAText: clear: return true");
                return true;
            }
            catch (DocumentException e) {
                System.out.println("NOAText: clear: WARNING: caught Exception");
                ExHandler.handle((Throwable)e);
            }
        }
        System.out.println("NOAText: clear: return false");
        return false;
    }

    public Composite createContainer(Composite parent, ITextPlugin.ICallback handler) {
        System.out.println("NOAText: createContainer(parent, handler) begin");
        System.out.println("NOAText: createContainer(): about to new Frame() - WARNING: I CANNOT SEE WHERE THIS IS STORED?");
        System.out.println("NOAText: createContainer(): about to new Frame() - WARNING: DISABLED FOR DEBUGGING.");
        System.out.println("NOAText: createContainer(): about to new Frame() - WARNING: Under Linux: No change, if disabled, and also in EditorCorePlugin.java - see workaround over there.");
        System.out.println("NOAText: createContainer(): about to panel = new(OfficePanel(parent, SWT.NONE)");
        this.panel = new OfficePanel(parent, 0);
        this.panel.setBuildAlwaysNewFrames(false);
        if (this.panel == null) {
            System.out.println("NOAText: createContainer(): WARNING: panel==null");
            System.out.println("NOAText: createContainer(): WARNING: panel.getFrame() consequently undefined");
        } else {
            System.out.println("NOAText: createContainer(): panel=" + this.panel.toString());
            if (this.panel.getFrame() == null) {
                System.out.println("NOAText: createContainer(): WARNING: panel.getFrame()==null");
            } else {
                System.out.println("NOAText: createContainer(): panel.getFrame()=" + this.panel.getFrame().toString());
            }
        }
        System.out.println("NOAText: createContainer(): about to office = EditorCorePlugin.getDefault().getManagedLocalOfficeApplication();");
        this.office = EditorCorePlugin.getDefault().getManagedLocalOfficeApplication();
        if (this.office == null) {
            System.out.println("NOAText: createContainer(): WARNING: office==null");
        } else {
            System.out.println("NOAText: createContainer(): office=" + this.office.toString());
        }
        System.out.println("NOAText: createContainer(): about return panel");
        return this.panel;
    }

    public boolean createEmptyDocument() {
        System.out.println("NOAText: createEmptyDocument() begin");
        try {
            System.out.println("NOAText: createEmptyDocument(): clean()...");
            this.clean();
            System.out.println("NOAText: createEmptyDocument(): about to get bundle=Platfrom.getBundle(\"com.jsigle.noatext_jsl\")");
            Bundle bundle = Platform.getBundle((String)"com.jsigle.noatext_jsl");
            if (bundle == null) {
                System.out.println("NOAText: createEmptyDocument(): ****************************************************");
                System.out.println("NOAText: createEmptyDocument(): WARNING: bundle==null - probably can't get empty.odt");
                System.out.println("NOAText: createEmptyDocument(): ****************************************************");
                System.out.println("NOAText: createEmptyDocument(): WARNING: THE CORRECT PLUGIN NAME MUST BE USED ABOVE!");
                System.out.println("NOAText: createEmptyDocument(): ****************************************************");
            } else {
                System.out.println("NOAText: createEmptyDocument(): bundle==" + bundle.toString());
            }
            Path path = new Path("rsc/empty.odt");
            System.out.println("NOAText: createEmptyDocument(): Copying internal ressource " + bundle.toString() + " " + path + " to new FileOutputStream...");
            InputStream is = FileLocator.openStream((Bundle)bundle, (IPath)path, (boolean)false);
            FileOutputStream fos = new FileOutputStream(this.myFile);
            FileTool.copyStreams((InputStream)is, (OutputStream)fos);
            is.close();
            fos.close();
            System.out.println("NOAText: createEmptyDocument(): about to panel.loadDocument(false, myFile.getAbsolutePath(), DocumentDescriptor.DEFAULT)...");
            this.panel.loadDocument(false, this.myFile.getAbsolutePath(), DocumentDescriptor.DEFAULT);
            this.createMe();
            System.out.println("NOAText: createEmptyDocument(): SUCCESS: This probably worked out. Returning true.");
            return true;
        }
        catch (Exception e) {
            System.out.println("NOAText: createEmptyDocument(): WARNING: caught Exception");
            ExHandler.handle((Throwable)e);
            System.out.println("NOAText: createEmptyDocument(): FAIL: Something probably went wrong. Returning false.");
            return false;
        }
    }

    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        System.out.println("NOAText: loadFromByteArray");
        if (bs == null) {
            this.log.log("Null-Array zum speichern!", 2);
            return false;
        }
        try {
            this.clean();
            FileOutputStream fout = new FileOutputStream(this.myFile);
            fout.write(bs);
            fout.close();
            this.panel.loadDocument(false, this.myFile.getAbsolutePath(), DocumentDescriptor.DEFAULT);
            this.createMe();
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        System.out.println("NOAText: loadFromStream");
        try {
            this.clean();
            this.doc = (ITextDocument)this.office.getDocumentService().loadDocument(is, (IDocumentDescriptor)DocumentDescriptor.DEFAULT_HIDDEN);
            if (this.doc != null) {
                this.doc.getPersistenceService().store(this.myFile.getAbsolutePath());
                this.doc.close();
                this.panel.loadDocument(false, this.myFile.getAbsolutePath(), DocumentDescriptor.DEFAULT);
                this.createMe();
            }
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
        }
        return false;
    }

    public byte[] storeToByteArray() {
        System.out.println("NOAText: storeToByteArray");
        if (this.doc == null) {
            return null;
        }
        try {
            this.doc.getPersistenceService().store(this.myFile.getAbsolutePath());
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.myFile));
            byte[] ret = new byte[(int)this.myFile.length()];
            int pos = 0;
            int len = 0;
            while (pos + (len = bis.read(ret)) != ret.length) {
                pos += len;
            }
            return ret;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }

    public void dispose() {
        System.out.println("NOAText: dispose");
        if (this.doc != null) {
            this.doc.close();
            this.doc = null;
        }
        if (this.panel != null) {
            this.panel.dispose();
        }
    }

    public boolean findOrReplace(String pattern, ReplaceCallback cb) {
        System.out.println("NOAText: findOrReplace: pattern: " + pattern);
        System.out.print("NOAText: findOrReplace: doc:     ");
        if (this.doc == null) {
            System.out.println("null");
        } else {
            System.out.print(this.doc.toString() + ", ");
            try {
                System.out.print(this.doc.getLocationURL().toString());
            }
            catch (DocumentException ex) {
                System.out.print("(LocationURL not available)");
            }
            System.out.println();
        }
        SearchDescriptor search = new SearchDescriptor(pattern);
        search.setUseRegularExpression(true);
        if (this.doc == null) {
            System.out.println("NOAText: findOrReplace: FEHLER: findOrReplace doc is null." + pattern);
            System.out.println("NOAText: findOrReplace: TODO: Bitte Fehlermeldung differenzieren und auf passende Stellen im Code verteilen,");
            System.out.println("                        TODO: ggf. mit Dialogen oder eingebautem intelligentem handling.");
            SWTHelper.showError((String)"findOrReplace doc is null", (String)"Fehler", (String)"NOAText: findOrReplace:\n\nDas Dokument ist nicht vorhanden oder nicht erreichbar.\nEnthaltene Platzhalter k\u00f6nnen nicht ersetzt werden.\n\nSicherheitshalber sollten Sie das Office-Dokument ggf. als Backup\nextern speichern, dann Elexis und LibreOffice/OpenOffice schliessen,\ndanach im Windows Task-Manager alle soffice.bin/soffice.exe schliessen,\nwelche definitiv zu keinem sichtbaren oder minimierten Fenster geh\u00f6ren.\n\nAnschliessend k\u00f6nnen Sie Elexis erneut starten. Dadurch arbeiten Sie wieder\nin einer definierten Umgebung, wenn Sie das Dokument erneut \u00f6ffnen.\n");
            return false;
        }
        String cWrongNumOfArgs = "*** Wrong number of arguments: Allowed number of arguments for this type of control: ";
        String cWrongNumOfArgs_2 = " ***";
        IFormService formService = this.doc.getFormService();
        try {
            IFormComponent[] formComponents = formService.getFormComponents();
            block29: for (int i = 0; i < formComponents.length; ++i) {
                try {
                    String replacement5;
                    IFormComponent formComponent = formComponents[i];
                    XPropertySet xPSet = formComponent.getXPropertySet();
                    int componentType = NOAText.getFormComponentType(xPSet);
                    try {
                        String controlName = (String)xPSet.getPropertyValue("Name");
                    }
                    catch (UnknownPropertyException e) {
                        break;
                    }
                    catch (WrappedTargetException e) {
                        break;
                    }
                    String replacement = (String)xPSet.getPropertyValue("Tag");
                    if (cb != null) {
                        Pattern p = Pattern.compile(pattern, 2);
                        Matcher m = p.matcher(replacement);
                        StringBuffer sb = new StringBuffer(replacement.length() * 4);
                        while (m.find()) {
                            int end;
                            int start = m.start();
                            String orig = replacement.substring(start, end = m.end());
                            Object replace = cb.replace(orig);
                            if (replace == null) {
                                m.appendReplacement(sb, "??Auswahl??");
                                continue;
                            }
                            if (replace instanceof String) {
                                String repl = ((String)replace).replaceAll("\\r", "\n");
                                repl = repl.replaceAll("\\n\\n+", "\n");
                                m.appendReplacement(sb, repl);
                                continue;
                            }
                            m.appendReplacement(sb, "Not a String");
                        }
                        m.appendTail(sb);
                        replacement = sb.toString();
                    }
                    xPSet.setPropertyValue("Tag", (Object)replacement);
                    String[] replacementParts = replacement.split("@@@");
                    String replacement1 = replacementParts[0];
                    String replacement2 = replacementParts.length >= 2 ? replacementParts[1] : null;
                    String replacement3 = replacementParts.length >= 3 ? replacementParts[2] : null;
                    String replacement4 = replacementParts.length >= 4 ? replacementParts[3] : null;
                    String string = replacement5 = replacementParts.length >= 5 ? replacementParts[4] : null;
                    if (StringTool.isNothing((Object)replacement1)) {
                        replacement1 = null;
                    }
                    if (StringTool.isNothing((Object)replacement2)) {
                        replacement2 = null;
                    }
                    if (StringTool.isNothing((Object)replacement3)) {
                        replacement3 = null;
                    }
                    if (StringTool.isNothing((Object)replacement4)) {
                        replacement4 = null;
                    }
                    if (StringTool.isNothing((Object)replacement5)) {
                        replacement5 = null;
                    }
                    String[] argumentsMapping = new String[]{"19:1", "12:1", "3:1", "5:1", "2:1", "10:1", "8:1", "4:1", "14:1", "7:2", "6:2", "15:3", "16:3", "17:4", "21:4", "18:4", "20:5"};
                    for (int argi = 0; argi < argumentsMapping.length; ++argi) {
                        String argMap = argumentsMapping[argi];
                        int argType = Integer.parseInt(argMap.split(":")[0]);
                        int argNumOfArgs = Integer.parseInt(argMap.split(":")[1]);
                        if (componentType != argType) continue;
                        String controlDefaultControl = (String)xPSet.getPropertyValue("DefaultControl");
                        if (controlDefaultControl.equalsIgnoreCase("com.sun.star.form.control.FormattedField")) {
                            if (replacementParts.length <= argNumOfArgs) break;
                            xPSet.setPropertyValue("Tag", (Object)(cWrongNumOfArgs + 3 + cWrongNumOfArgs_2));
                            break;
                        }
                        if (replacementParts.length <= argNumOfArgs) break;
                        xPSet.setPropertyValue("Tag", (Object)(cWrongNumOfArgs + argNumOfArgs + cWrongNumOfArgs_2));
                        break;
                    }
                    if ((componentType == 7 || componentType == 6) && (replacement2 = replacement2.replaceAll("\\n", ";")) != null) {
                        xPSet.setPropertyValue("StringItemList", (Object)replacement2.split(";"));
                    }
                    switch (componentType) {
                        case 7: 
                        case 9: 
                        case 12: 
                        case 19: {
                            String controlDefaultControl = (String)xPSet.getPropertyValue("DefaultControl");
                            if (controlDefaultControl.equalsIgnoreCase("com.sun.star.form.control.FormattedField")) {
                                if (this.isInteger(replacement1)) {
                                    xPSet.setPropertyValue("EffectiveValue", (Object)new Short((short)Integer.parseInt(replacement1)));
                                }
                                if (this.isInteger(replacement2)) {
                                    xPSet.setPropertyValue("EffectiveMin", (Object)new Short((short)Integer.parseInt(replacement2)));
                                }
                                if (!this.isInteger(replacement3)) break;
                                xPSet.setPropertyValue("EffectiveMax", (Object)new Short((short)Integer.parseInt(replacement3)));
                                break;
                            }
                            XTextComponent xTextComponent = formComponent.getXTextComponent();
                            if (replacement1 == null) continue block29;
                            xTextComponent.setText(replacement1);
                            break;
                        }
                        case 15: {
                            String yyyymmddDate;
                            TimeTool timeTool = new TimeTool();
                            if (timeTool.set(replacement1) && !StringTool.isNothing((Object)(yyyymmddDate = timeTool.toString(9)))) {
                                xPSet.setPropertyValue("Date", (Object)Integer.parseInt(yyyymmddDate));
                            }
                            if (timeTool.set(replacement2) && !StringTool.isNothing((Object)(yyyymmddDate = timeTool.toString(9)))) {
                                xPSet.setPropertyValue("DateMin", (Object)Integer.parseInt(yyyymmddDate));
                            }
                            if (!timeTool.set(replacement3)) break;
                            yyyymmddDate = timeTool.toString(9);
                            if (StringTool.isNothing((Object)yyyymmddDate)) continue block29;
                            xPSet.setPropertyValue("DateMax", (Object)Integer.parseInt(yyyymmddDate));
                            break;
                        }
                        case 16: {
                            TimeTool timeTool2 = new TimeTool();
                            if (timeTool2.set(replacement1)) {
                                String hhmmssTime = timeTool2.toString(2);
                                if (!StringTool.isNothing((Object)(hhmmssTime = hhmmssTime.replaceAll(":", "") + "00"))) {
                                    xPSet.setPropertyValue("Time", (Object)Integer.parseInt(hhmmssTime));
                                }
                            }
                            if (timeTool2.set(replacement2)) {
                                String hhmmssTime = timeTool2.toString(2);
                                if (!StringTool.isNothing((Object)(hhmmssTime = hhmmssTime.replaceAll(":", "") + "00"))) {
                                    xPSet.setPropertyValue("TimeMin", (Object)Integer.parseInt(hhmmssTime));
                                }
                            }
                            if (!timeTool2.set(replacement3)) break;
                            String hhmmssTime = timeTool2.toString(2);
                            if (StringTool.isNothing((Object)(hhmmssTime = hhmmssTime.replaceAll(":", "") + "00"))) continue block29;
                            xPSet.setPropertyValue("TimeMax", (Object)Integer.parseInt(hhmmssTime));
                            break;
                        }
                        case 17: 
                        case 18: {
                            if (this.isInteger(replacement1)) {
                                xPSet.setPropertyValue("Value", (Object)new Short((short)Integer.parseInt(replacement1)));
                            }
                            if (this.isInteger(replacement2)) {
                                xPSet.setPropertyValue("ValueMin", (Object)new Short((short)Integer.parseInt(replacement2)));
                            }
                            if (this.isInteger(replacement3)) {
                                xPSet.setPropertyValue("ValueMax", (Object)new Short((short)Integer.parseInt(replacement3)));
                            }
                            if (!this.isInteger(replacement4)) break;
                            xPSet.setPropertyValue("ValueStep", (Object)new Short((short)Integer.parseInt(replacement4)));
                            break;
                        }
                        case 3: 
                        case 5: {
                            if (!this.isInteger(replacement1)) break;
                            xPSet.setPropertyValue("State", (Object)new Short((short)Integer.parseInt(replacement1)));
                            break;
                        }
                        case 2: 
                        case 8: 
                        case 10: {
                            if (replacement1 == null) break;
                            xPSet.setPropertyValue("Label", (Object)replacement1);
                            break;
                        }
                        case 6: {
                            replacement1 = replacement1.replaceAll("\\n", ";");
                            String[] splittedArgs = replacement1.split(";");
                            short[] shortList = new short[splittedArgs.length];
                            for (int argsi = 0; argsi < splittedArgs.length; ++argsi) {
                                short arg;
                                String argStr = splittedArgs[argsi];
                                if (!this.isInteger(argStr)) continue;
                                shortList[argsi] = arg = (short)Integer.parseInt(argStr);
                            }
                            if (replacement1 == null) break;
                            xPSet.setPropertyValue("SelectedItems", (Object)shortList);
                            break;
                        }
                        case 21: {
                            if (this.isInteger(replacement3)) {
                                xPSet.setPropertyValue("SpinValueMax", (Object)new Short((short)Integer.parseInt(replacement3)));
                            }
                            if (this.isInteger(replacement2)) {
                                xPSet.setPropertyValue("SpinValueMin", (Object)new Short((short)Integer.parseInt(replacement2)));
                            }
                            if (this.isInteger(replacement4)) {
                                xPSet.setPropertyValue("SpinIncrement", (Object)new Short((short)Integer.parseInt(replacement4)));
                            }
                            if (!this.isInteger(replacement1)) break;
                            xPSet.setPropertyValue("SpinValue", (Object)new Short((short)Integer.parseInt(replacement1)));
                            break;
                        }
                        case 20: {
                            if (this.isInteger(replacement1)) {
                                xPSet.setPropertyValue("ScrollValue", (Object)new Short((short)Integer.parseInt(replacement1)));
                            }
                            if (this.isInteger(replacement2)) {
                                xPSet.setPropertyValue("ScrollValueMin", (Object)new Short((short)Integer.parseInt(replacement2)));
                            }
                            if (this.isInteger(replacement3)) {
                                xPSet.setPropertyValue("ScrollValueMax", (Object)new Short((short)Integer.parseInt(replacement3)));
                            }
                            if (this.isInteger(replacement4)) {
                                xPSet.setPropertyValue("LineIncrement", (Object)new Short((short)Integer.parseInt(replacement4)));
                            }
                            if (!this.isInteger(replacement5)) break;
                            xPSet.setPropertyValue("BlockIncrement", (Object)new Short((short)Integer.parseInt(replacement5)));
                            break;
                        }
                        case 4: 
                        case 14: {
                            if (replacement1 == null) break;
                            xPSet.setPropertyValue("ImageURL", (Object)replacement1);
                        }
                    }
                    continue;
                }
                catch (NOAException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (UnknownPropertyException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (WrappedTargetException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (NOAException e1) {
            e1.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ISearchResult searchResult = this.doc.getSearchService().findAll(search);
        if (!searchResult.isEmpty()) {
            ITextRange[] textRanges = searchResult.getTextRanges();
            if (cb != null) {
                for (ITextRange r : textRanges) {
                    String orig = r.getXTextRange().getString();
                    System.out.println("js NOAText.java findOrReplace() orig=" + orig);
                    Object replace = cb.replace(orig);
                    if (replace == null) {
                        r.setText("??Auswahl??");
                        continue;
                    }
                    if (replace instanceof String) {
                        System.out.println("js NOAText.java findOrReplace() (String) replace=" + (String)replace);
                        String repl = ((String)replace).replaceAll("\\r\\n", "\r");
                        repl = repl.replaceAll("\\n", "\r");
                        repl = repl.replaceAll("\\r+", "\r");
                        r.setText(repl);
                        continue;
                    }
                    if (replace instanceof String[][]) {
                        String[][] contents = (String[][])replace;
                        System.out.println("js NOAText.java findOrReplace() (String[][]) contents (of replace)=" + contents);
                        try {
                            ITextTable textTable = this.doc.getTextTableService().constructTextTable(contents.length, contents[0].length);
                            this.doc.getTextService().getTextContentService().insertTextContent(r, textTable);
                            r.setText("");
                            ITextTablePropertyStore props = textTable.getPropertyStore();
                            for (int row = 0; row < contents.length; ++row) {
                                String[] zeile = contents[row];
                                for (int col = 0; col < zeile.length; ++col) {
                                    textTable.getCell(col, row).getTextService().getText().setText(zeile[col]);
                                }
                            }
                            textTable.spreadColumnsEvenly();
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            r.setText("Fehler beim Ersetzen");
                        }
                        continue;
                    }
                    r.setText("Not a String");
                }
            }
            return true;
        }
        return false;
    }

    public boolean isInteger(String input) {
        System.out.println("NOAText: isInteger");
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getFormComponentType(XPropertySet xComponent) {
        System.out.println("NOAText: js getFormComponentType begin - log.log() not available here");
        XPropertySetInfo xPSI = null;
        if (null != xComponent) {
            xPSI = xComponent.getPropertySetInfo();
        }
        if (null != xPSI && xPSI.hasPropertyByName("ClassId")) {
            XPropertySet xCompProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xComponent);
            try {
                return ((Short)xCompProps.getPropertyValue("ClassId")).shortValue();
            }
            catch (UnknownPropertyException e) {
                e.printStackTrace();
            }
            catch (WrappedTargetException e) {
                e.printStackTrace();
            }
        }
        System.out.println("NOAText: js getFormComponentType end - log.log() not available here");
        return 0;
    }

    public ITextPlugin.PageFormat getFormat() {
        System.out.println("NOAText: getFormat");
        return ITextPlugin.PageFormat.USER;
    }

    public String getMimeType() {
        System.out.println("NOAText: getMimeType");
        return MIMETYPE_OO2;
    }

    public boolean insertTable(String place, int properties, String[][] contents, int[] columnSizes) {
        System.out.println("NOAText: insertTable: begin");
        System.out.println("NOAText: insertTable: place=" + place);
        System.out.println("NOAText: insertTable: properties=" + properties);
        System.out.println("NOAText: insertTable: contents=" + contents);
        int offset = 0;
        if ((properties & 1) == 0) {
            offset = 1;
        }
        SearchDescriptor search = new SearchDescriptor(place);
        search.setIsCaseSensitive(true);
        ISearchResult searchResult = this.doc.getSearchService().findFirst(search);
        if (!searchResult.isEmpty()) {
            ITextRange r = searchResult.getTextRanges()[0];
            try {
                ITextTable textTable = this.doc.getTextTableService().constructTextTable(contents.length + offset, contents[0].length);
                this.doc.getTextService().getTextContentService().insertTextContent(r, textTable);
                r.setText("");
                ITextTablePropertyStore props = textTable.getPropertyStore();
                long w = props.getWidth();
                long percent = w / 100L;
                for (int row = 0; row < contents.length; ++row) {
                    String[] zeile = contents[row];
                    for (int col = 0; col < zeile.length; ++col) {
                        textTable.getCell(col, row + offset).getTextService().getText().setText(zeile[col]);
                    }
                }
                if (columnSizes == null) {
                    textTable.spreadColumnsEvenly();
                } else {
                    for (int col = 0; col < contents[0].length; ++col) {
                        textTable.getColumn(col).setWidth((short)((long)columnSizes[col] * percent));
                    }
                }
                XTextTable myXTextTable = textTable.getXTextTable();
                if (myXTextTable != null) {
                    XPropertySet myXPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)myXTextTable);
                    if (myXPropertySet != null) {
                        XPropertySetInfo myXPropertySetInfo = myXPropertySet.getPropertySetInfo();
                        if (myXPropertySetInfo != null) {
                            Property[] myPropertyArray = myXPropertySetInfo.getProperties();
                            if (myPropertyArray != null) {
                                for (Property p : myPropertyArray) {
                                    System.out.println("js NOAText: insertTable: Property p.Name=" + p.Name);
                                }
                            } else {
                                System.out.println("js NOAText: insertTable: WARNING: myPropertyArray == null");
                            }
                        } else {
                            System.out.println("js NOAText: insertTable: WARNING: myXPropertySetInfo == null");
                        }
                        Property myTableBorder = myXPropertySetInfo.getPropertyByName("TableBorder");
                        short inner = 0;
                        short outer = 0;
                        short distance = 0;
                        TableBorder t = new TableBorder();
                        t.TopLine.InnerLineWidth = inner;
                        t.TopLine.OuterLineWidth = outer;
                        t.TopLine.LineDistance = distance;
                        t.IsTopLineValid = true;
                        t.BottomLine.InnerLineWidth = inner;
                        t.BottomLine.OuterLineWidth = outer;
                        t.BottomLine.LineDistance = distance;
                        t.IsBottomLineValid = true;
                        t.LeftLine.InnerLineWidth = inner;
                        t.LeftLine.OuterLineWidth = outer;
                        t.LeftLine.LineDistance = distance;
                        t.IsLeftLineValid = true;
                        t.RightLine.InnerLineWidth = inner;
                        t.RightLine.OuterLineWidth = outer;
                        t.RightLine.LineDistance = distance;
                        t.IsRightLineValid = true;
                        t.HorizontalLine.InnerLineWidth = inner;
                        t.HorizontalLine.OuterLineWidth = outer;
                        t.HorizontalLine.LineDistance = distance;
                        t.IsHorizontalLineValid = true;
                        t.VerticalLine.InnerLineWidth = inner;
                        t.VerticalLine.OuterLineWidth = outer;
                        t.VerticalLine.LineDistance = distance;
                        t.IsVerticalLineValid = true;
                        try {
                            System.out.println("js NOAText: insertTable: about to myXPropertySet.setPropertyValue(\"TableBorder\", t)...");
                            myXPropertySet.setPropertyValue("TableBorder", (Object)t);
                        }
                        catch (UnknownPropertyException e) {
                            System.out.println("js NOAText: insertTable: WARNING: caught exception UnknownPropertyException");
                            e.printStackTrace();
                        }
                        catch (PropertyVetoException e) {
                            System.out.println("js NOAText: insertTable: WARNING: caught exception PropertyVetoException");
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            System.out.println("js NOAText: insertTable: WARNING: caught exception com.sun.star.lang.IllegalArgumentException");
                            e.printStackTrace();
                        }
                        catch (WrappedTargetException e) {
                            System.out.println("js NOAText: insertTable: WARNING: caught exception WrappedTargetException");
                            e.printStackTrace();
                        }
                    } else {
                        System.out.println("js NOAText: insertTable: WARNING: myXPropertySet == null");
                    }
                } else {
                    System.out.println("js NOAText: insertTable: WARNING: myXTextTable == null");
                }
                if (textTable.getColumnCount() > 0 && textTable.getRowCount() > 0) {
                    System.out.println("js NOAText: insertTable: Cell(0,0).getCellParagraphStyle()=" + textTable.getCell(0, 0).getCellParagraphStyle());
                    System.out.println("js NOAText: insertTable: Cell(1,1).getCellParagraphStyle()=" + textTable.getCell(1, 1).getCellParagraphStyle());
                }
                System.out.println("NOAText: insertTable: about to return true");
                return true;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
        System.out.println("NOAText: insertTable: about to return false");
        return false;
    }

    public Object insertText(String marke, String text, int adjust) {
        System.out.println("NOAText: insertText, return a cursor");
        SearchDescriptor search = new SearchDescriptor(marke);
        search.setIsCaseSensitive(true);
        ISearchResult searchResult = this.doc.getSearchService().findFirst(search);
        XText myText = this.doc.getXTextDocument().getText();
        XTextCursor cur = myText.createTextCursor();
        if (!searchResult.isEmpty()) {
            ITextRange r = searchResult.getTextRanges()[0];
            cur = myText.createTextCursorByRange(r.getXTextRange());
            cur.setString(text);
            try {
                this.setFormat(cur);
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
            }
            cur.collapseToEnd();
        }
        return cur;
    }

    public Object insertText(Object pos, String text, int adjust) {
        System.out.println("NOAText: insertText at pos returned");
        XTextCursor cur = (XTextCursor)pos;
        if (cur != null) {
            cur.setString(text);
            try {
                this.setFormat(cur);
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
            }
            cur.collapseToEnd();
        }
        return cur;
    }

    public Object insertTextAt(int x, int y, int w, int h, String text, int adjust) {
        System.out.println("NOAText: insertTextAt");
        try {
            ParagraphAdjust paradj;
            XTextDocument myDoc = this.doc.getXTextDocument();
            XMultiServiceFactory documentFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)myDoc);
            Object frame = documentFactory.createInstance("com.sun.star.text.TextFrame");
            XText docText = myDoc.getText();
            XTextFrame xFrame = (XTextFrame)UnoRuntime.queryInterface(XTextFrame.class, (Object)frame);
            XShape xWriterShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)xFrame);
            xWriterShape.setSize(new Size(w * 100, h * 100));
            XPropertySet xFrameProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFrame);
            xFrameProps.setPropertyValue("AnchorPageNo", (Object)new Short(1));
            xFrameProps.setPropertyValue("VertOrientRelation", (Object)7);
            xFrameProps.setPropertyValue("AnchorType", (Object)TextContentAnchorType.AT_PAGE);
            xFrameProps.setPropertyValue("HoriOrient", (Object)0);
            xFrameProps.setPropertyValue("VertOrient", (Object)0);
            xFrameProps.setPropertyValue("HoriOrientPosition", (Object)(x * 100));
            xFrameProps.setPropertyValue("VertOrientPosition", (Object)(y * 100));
            XTextCursor docCursor = docText.createTextCursor();
            docCursor.gotoStart(false);
            docText.insertTextContent((XTextRange)docCursor, (XTextContent)xFrame, false);
            XText xFrameText = xFrame.getText();
            XTextCursor xtc = xFrameText.createTextCursor();
            XPropertySet charProps = this.setFormat(xtc);
            switch (adjust) {
                case 16384: {
                    paradj = ParagraphAdjust.LEFT;
                    break;
                }
                case 131072: {
                    paradj = ParagraphAdjust.RIGHT;
                    break;
                }
                default: {
                    paradj = ParagraphAdjust.CENTER;
                }
            }
            charProps.setPropertyValue("ParaAdjust", (Object)paradj);
            xFrameText.insertString((XTextRange)xtc, text, false);
            return xtc;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public boolean print(String toPrinter, String toTray, boolean waitUntilFinished) {
        System.out.println("NOAText: print");
        try {
            XTextDocument myDoc;
            PropertyValue[] pprops;
            if (StringTool.isNothing((Object)toPrinter)) {
                pprops = new PropertyValue[]{new PropertyValue()};
                pprops[0].Name = "Pages";
                pprops[0].Value = "1-";
            } else {
                pprops = new PropertyValue[2];
                pprops[0] = new PropertyValue();
                pprops[0].Name = "Pages";
                pprops[0].Value = "1-";
                pprops[1] = new PropertyValue();
                pprops[1].Name = "Name";
                pprops[1].Value = toPrinter;
            }
            if (!StringTool.isNothing((Object)toTray) && !OOPrinter.setPrinterTray(myDoc = this.doc.getXTextDocument(), toTray)) {
                return false;
            }
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.doc.getXTextDocument());
            XPrintJobBroadcaster selection = (XPrintJobBroadcaster)UnoRuntime.queryInterface(XPrintJobBroadcaster.class, (Object)xPrintable);
            OOPrinter.MyXPrintJobListener myXPrintJobListener = new OOPrinter.MyXPrintJobListener();
            selection.addPrintJobListener((XPrintJobListener)myXPrintJobListener);
            xPrintable.print(pprops);
            long timeout = System.currentTimeMillis();
            while (myXPrintJobListener.getStatus() == null || myXPrintJobListener.getStatus() == PrintableState.JOB_STARTED) {
                Thread.sleep(100L);
                long to = System.currentTimeMillis();
                if (to - timeout <= 10000L) continue;
                break;
            }
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public void setFocus() {
        System.out.println("NOAText: setFocus stub");
    }

    public void setFormat(ITextPlugin.PageFormat f) {
        System.out.println("NOAText: PageFormat stub");
    }

    public void setSaveOnFocusLost(boolean bSave) {
        System.out.println("NOAText: setSaveOnFocusLost stub");
    }

    public void showMenu(boolean b) {
        System.out.println("NOAText: showMenu stub");
    }

    public void showToolbar(boolean b) {
        System.out.println("NOAText: showToolbar stub");
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        System.out.println("NOAText: setInitializationData stub");
    }

    private void clean() {
        System.out.println("NOAText: clean");
        try {
            if (this.doc != null) {
                this.doc.getPersistenceService().store(this.myFile.getAbsolutePath());
                this.myFile.delete();
            }
            System.out.println("NOAText: clean: constructing temp file name...");
            System.out.println("NOAText: TODO: Code to include Fall related info is already here in NOAText.java; but commented out, because NOAText probably knows too little.");
            StringBuffer configured_temp_filename = new StringBuffer();
            System.out.println("NOAText: clean(): configured_temp_filename=" + configured_temp_filename.toString());
            configured_temp_filename.append(LocalOfficeApplicationPreferencesPage.getNOAText_jslTemp_Filename_Element("constant1", ""));
            System.out.println("NOAText: clean(): configured_temp_filename=" + configured_temp_filename.toString());
            Patient pat = ElexisEventDispatcher.getSelectedPatient();
            if (pat != null) {
                configured_temp_filename.append(LocalOfficeApplicationPreferencesPage.getNOAText_jslTemp_Filename_Element("PID", pat.getKuerzel()));
                System.out.println("NOAText: clean(): configured_temp_filename=" + configured_temp_filename.toString());
                configured_temp_filename.append(LocalOfficeApplicationPreferencesPage.getNOAText_jslTemp_Filename_Element("fn", pat.getName()));
                System.out.println("NOAText: clean(): configured_temp_filename=" + configured_temp_filename.toString());
                configured_temp_filename.append(LocalOfficeApplicationPreferencesPage.getNOAText_jslTemp_Filename_Element("gn", pat.getVorname()));
                System.out.println("NOAText: clean(): configured_temp_filename=" + configured_temp_filename.toString());
                configured_temp_filename.append(LocalOfficeApplicationPreferencesPage.getNOAText_jslTemp_Filename_Element("dob", pat.getGeburtsdatum()));
                System.out.println("NOAText: clean(): configured_temp_filename=" + configured_temp_filename.toString());
            }
            System.out.println("NOAText: clean: TODO: Add the elexis Briefauswahl document name to the temporary filename.");
            System.out.println("NOAText: clean: TODO: Please note: This must work for creating a new document, opening an existing one, and renaming one.");
            System.out.println("NOAText: clean: TODO: Also note that documents may be opened from other sources than BriefAuswahl; i.e. Rezepte etc. and cover these ways.");
            System.out.println("NOAText: clean: TODO: The all underlying problem is that NOAText may simply not know the elexis metadata for the document it handles.");
            if (!configured_temp_filename.toString().isEmpty()) {
                StringBuffer filename_clean = new StringBuffer();
                for (int n = 0; n < configured_temp_filename.length(); ++n) {
                    String c = configured_temp_filename.substring(n, n + 1);
                    if (c.codePointAt(0) < 32 || "\\/:*?()+,;\"'\u00b4`".contains(c)) continue;
                    filename_clean.append(c);
                }
                configured_temp_filename = filename_clean;
                System.out.println("NOAText: clean: configured_temp_filename=<" + configured_temp_filename + ">");
                System.out.println("NOAText: clean: about to createTempFile(\"noa_\"+configured_temp_filename, \".odt\")...");
                this.myFile = File.createTempFile(configured_temp_filename.toString().trim(), ".odt");
            } else {
                System.out.println("NOAText: clean: about to createTempFile(\"noa\", \".odt\")...");
                this.myFile = File.createTempFile("noa", ".odt");
            }
            this.myFile.deleteOnExit();
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    public boolean setFont(String name, int style, float size) {
        System.out.println("NOAText: setFont");
        this.font = name;
        this.hi = size;
        this.stil = style;
        return true;
    }

    public boolean setStyle(int style) {
        System.out.println("NOAText: setStyle");
        this.stil = style;
        return true;
    }

    private XPropertySet setFormat(XTextCursor xtc) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        System.out.println("NOAText: setFormat");
        XPropertySet charProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xtc);
        if (this.font != null) {
            charProps.setPropertyValue("CharFontName", (Object)this.font);
        }
        if (this.hi > 0.0f) {
            charProps.setPropertyValue("CharHeight", (Object)new Float(this.hi));
        }
        if (this.stil > -1) {
            switch (this.stil) {
                case 128: {
                    charProps.setPropertyValue("CharWeight", (Object)Float.valueOf(15.0f));
                    break;
                }
                case 0: {
                    charProps.setPropertyValue("CharWeight", (Object)Float.valueOf(75.0f));
                    break;
                }
                case 1: {
                    charProps.setPropertyValue("CharWeight", (Object)Float.valueOf(150.0f));
                }
            }
        }
        return charProps;
    }

    public boolean isDirectOutput() {
        System.out.println("NOAText: isDirectOutput - always returns false");
        return false;
    }

    class closeListener
    implements ICloseListener {
        private IOfficeApplication officeAplication = null;

        public closeListener(IOfficeApplication officeAplication) {
            System.out.println("NOAText: closeListener: closeListener");
            this.officeAplication = officeAplication;
        }

        @Override
        public void queryClosing(ICloseEvent closeEvent, boolean getsOwnership) {
            System.out.println("NOAText: closeListener: queryClosing nop");
        }

        @Override
        public void notifyClosing(ICloseEvent closeEvent) {
            System.out.println("NOAText: closeListener: notifyClosing");
            try {
                NOAText.this.removeMe();
            }
            catch (Exception exception) {
                System.err.println("Error closing office application!");
                exception.printStackTrace();
            }
        }

        @Override
        public void disposing(IEvent event) {
            System.out.println("NOAText: closeListener: disposing nop");
        }
    }
}

