/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa4e.ui.widgets;

import ag.ion.bion.officelayer.OSHelper;
import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import ag.ion.bion.workbench.office.editor.core.EditorCorePlugin;
import ag.ion.noa4e.ui.NOAUIPlugin;
import ag.ion.noa4e.ui.operations.AsyncProgressMonitorWrapper;
import ag.ion.noa4e.ui.operations.LoadDocumentOperation;
import ag.ion.noa4e.ui.widgets.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Panel;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class OfficePanel
extends Composite {
    private IOfficeApplication officeApplication = null;
    private IFrame officeFrame = null;
    private StackLayout stackLayout = null;
    private Frame officeAWTFrame = null;
    private ProgressMonitorPart progressMonitorPart = null;
    private Composite baseComposite = null;
    private Composite progressComposite = null;
    private Composite officeComposite = null;
    private IDocument document = null;
    private IStatus lastLoadingStatus = null;
    private Thread loadingThread = null;
    private String currentDocumentPath = null;
    private boolean buildAlwaysNewFrames = false;
    private boolean showProgressIndicator = true;

    public OfficePanel(Composite parent, int style) {
        this(parent, style, null);
    }

    public OfficePanel(Composite parent, int style, IOfficeApplication officeApplication) {
        super(parent, style);
        System.out.println("OfficePanel: OfficePanel(3): just returned from super(parent, style)");
        System.out.println("OfficePanel: OfficePanel(3): about to buildControls()");
        this.buildControls();
        System.out.println("OfficePanel: OfficePanel(3): just returned from buildControls()");
        if (officeApplication == null) {
            System.out.println("OfficePanel: OfficePanel(3): officeApplication==null");
        } else {
            System.out.println("OfficePanel: OfficePanel(3): officeApplication=" + officeApplication.toString());
        }
        if (officeApplication == null) {
            System.out.println("OfficePanel: OfficePanel(3): about to EditorCorePlugin.getDefault().getManagedLocalOfficeApplication()");
            officeApplication = EditorCorePlugin.getDefault().getManagedLocalOfficeApplication();
        }
        if (officeApplication == null) {
            System.out.println("OfficePanel: OfficePanel(3): WARNING: about to return this.officeApplication==null");
        } else {
            System.out.println("OfficePanel: OfficePanel(3): returning this.officeApplication=" + officeApplication.toString());
        }
        this.officeApplication = officeApplication;
    }

    public IFrame getFrame() {
        System.out.println("OfficePanel: getFrame()");
        if (this.officeFrame == null) {
            System.out.println("OfficePanel: getFrame(): WARNING: about to return officeFrame==null");
        } else {
            System.out.println("OfficePanel: getFrame(): returning officeFrame=" + this.officeFrame.toString());
        }
        return this.officeFrame;
    }

    public IDocument getDocument() {
        System.out.println("OfficePanel: getDocument()");
        if (this.document == null) {
            System.out.println("OfficePanel: getDocument(): WARNING: about to return document==null");
        } else {
            System.out.println("OfficePanel: getDocument(): returning document=" + this.document.toString());
        }
        return this.document;
    }

    public boolean setFocus() {
        System.out.println("OfficePanel: setFocus()");
        if (this.officeFrame == null) {
            System.out.println("OfficePanel: setFocus(): WARNING: officeFrame==null; will return super.setFocus() instead");
        } else {
            System.out.println("OfficePanel: setFocus(): about to officeFrame.setFocus() for officeFrame=" + this.officeFrame.toString());
        }
        if (this.officeFrame != null) {
            this.officeFrame.setFocus();
            return true;
        }
        return super.setFocus();
    }

    public void setBuildAlwaysNewFrames(boolean buildAlwaysNewFrames) {
        System.out.println("OfficePanel: setBuildAlwaysNewFrames(buildAlwaysNewFrames)");
        System.out.println("OfficePanel: setBuildAlwaysNewFrames(): about to set this.buildAlwaysNewFrames=" + buildAlwaysNewFrames);
        this.buildAlwaysNewFrames = buildAlwaysNewFrames;
    }

    public void showProgressIndicator(boolean showProgressIndicator) {
        System.out.println("OfficePanel: showProgressIndicator(showProgressIndicator)");
        System.out.println("OfficePanel: showProgressIndicator(): about to set this.showProgressIndicator=" + showProgressIndicator);
        this.showProgressIndicator = showProgressIndicator;
    }

    public final void loadDocument(boolean fork, final String documentPath, final IDocumentDescriptor documentDescriptor) {
        System.out.println("OfficePanel: loadDocument(fork, documentPath, documentDescriptor) begin");
        if (this.isDisposed()) {
            System.out.println("OfficePanel: loadDocument(3): WARNING: isDisposed==true; will return immediately.");
            return;
        }
        System.out.println("OfficePanel: loadDocument(3): Status before doing the work:");
        if (documentPath == null) {
            System.out.println("OfficePanel: loadDocument(3): documentPath==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): documentPath=" + documentPath);
        }
        if (this.currentDocumentPath == null) {
            System.out.println("OfficePanel: loadDocument(3): currentDocumentPath==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): currentDocumentPath=" + this.currentDocumentPath);
        }
        if (this.document == null) {
            System.out.println("OfficePanel: loadDocument(3): document==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): document=" + this.document.toString());
        }
        if (this.officeFrame == null) {
            System.out.println("OfficePanel: loadDocument(3): officeFrame==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): officeFrame=" + this.officeFrame.toString());
        }
        if (this.lastLoadingStatus == null) {
            System.out.println("OfficePanel: loadDocument(3): lastLoadingStatus==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): lastLoadingStatus=" + this.lastLoadingStatus.toString());
        }
        if (!(documentPath == null || this.currentDocumentPath != null && this.currentDocumentPath.equals(documentPath))) {
            try {
                System.out.println("OfficePanel: loadDocument(3): Setting currentDocumentPath=documentPath;");
                this.currentDocumentPath = documentPath;
                if (this.document != null && this.buildAlwaysNewFrames) {
                    System.out.println("OfficePanel: loadDocument(3): closing currently open document...");
                    this.document.close();
                }
                if (this.officeFrame == null || this.buildAlwaysNewFrames) {
                    System.out.println("OfficePanel: loadDocument(3): activating new officeFrame...");
                    this.officeFrame = this.activateNewFrame();
                    if (this.officeFrame == null) {
                        System.out.println("OfficePanel: loadDocument(3): WARNING: FAILED: still, officeFrame==null");
                    } else {
                        System.out.println("OfficePanel: loadDocument(3): SUCCESS: officeFrame=" + this.officeFrame.toString());
                    }
                }
                if (!fork) {
                    System.out.println("OfficePanel: loadDocument(3): fork=false");
                    IProgressMonitor progressMonitor = this.getProgressMonitor();
                    if (progressMonitor == null) {
                        System.out.println("OfficePanel: loadDocument(3): progressMonitor==null");
                    } else {
                        System.out.println("OfficePanel: loadDocument(3): progressMonitor=" + progressMonitor.toString());
                    }
                    if (this.showProgressIndicator) {
                        this.showProgressIndicator();
                    }
                    System.out.println("OfficePanel: loadDocument(3): loading document...");
                    if (documentPath == null) {
                        System.out.println("OfficePanel: loadDocument(3): documentPath==null");
                    } else {
                        System.out.println("OfficePanel: loadDocument(3): documentPath=" + documentPath.toString());
                    }
                    if (documentDescriptor == null) {
                        System.out.println("OfficePanel: loadDocument(3): documentDescriptor==null");
                    } else {
                        System.out.println("OfficePanel: loadDocument(3): documentDescriptor=" + documentDescriptor.toString());
                    }
                    if (progressMonitor == null) {
                        System.out.println("OfficePanel: loadDocument(3): progressMonitor==null");
                    } else {
                        System.out.println("OfficePanel: loadDocument(3): progressMonitor=" + progressMonitor.toString());
                    }
                    this.loadDocument(documentPath, documentDescriptor, progressMonitor);
                    if (this.document != null) {
                        this.lastLoadingStatus = Status.OK_STATUS;
                    }
                    if (this.document == null) {
                        System.out.println("OfficePanel: loadDocument(3): WARNING: FAILED: document==null");
                    } else {
                        System.out.println("OfficePanel: loadDocument(3): SUCCESS: document=" + this.document.toString());
                    }
                    if (this.showProgressIndicator) {
                        this.hideProgressIndicator();
                        this.showOfficeFrame();
                    }
                } else {
                    System.out.println("OfficePanel: loadDocument(3): fork=true");
                    final Display display = Display.getCurrent();
                    this.loadingThread = new Thread(){
                        AsyncProgressMonitorWrapper asyncProgressMonitorWrapper = null;

                        @Override
                        public void run() {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!OfficePanel.this.isDisposed() && OfficePanel.this.showProgressIndicator) {
                                        OfficePanel.this.showProgressIndicator();
                                    }
                                }
                            });
                            this.asyncProgressMonitorWrapper = new AsyncProgressMonitorWrapper(OfficePanel.this.getProgressMonitor(), OfficePanel.this.getDisplay());
                            try {
                                OfficePanel.this.loadDocument(documentPath, documentDescriptor, this.asyncProgressMonitorWrapper);
                                if (OfficePanel.this.document != null) {
                                    OfficePanel.this.lastLoadingStatus = Status.OK_STATUS;
                                }
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (OfficePanel.this.showProgressIndicator) {
                                            OfficePanel.this.hideProgressIndicator();
                                            OfficePanel.this.showOfficeFrame();
                                        }
                                    }
                                });
                            }
                            catch (CoreException coreException) {
                                if (OfficePanel.this.showProgressIndicator) {
                                    OfficePanel.this.hideProgressIndicator();
                                    OfficePanel.this.showOfficeFrame();
                                }
                                OfficePanel.this.lastLoadingStatus = coreException.getStatus();
                            }
                        }
                    };
                    this.loadingThread.start();
                }
            }
            catch (Throwable throwable) {
                if (this.showProgressIndicator) {
                    this.hideProgressIndicator();
                    this.showOfficeFrame();
                }
                this.lastLoadingStatus = new Status(4, "ag.ion.noa4e.ui", 4, throwable.getMessage(), throwable);
            }
        }
        System.out.println("OfficePanel: loadDocument(3): Status after doing the work:");
        if (documentPath == null) {
            System.out.println("OfficePanel: loadDocument(3): documentPath==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): documentPath=" + documentPath);
        }
        if (this.currentDocumentPath == null) {
            System.out.println("OfficePanel: loadDocument(3): currentDocumentPath==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): currentDocumentPath=" + this.currentDocumentPath);
        }
        if (this.document == null) {
            System.out.println("OfficePanel: loadDocument(3): document==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): document=" + this.document.toString());
        }
        if (this.officeFrame == null) {
            System.out.println("OfficePanel: loadDocument(3): officeFrame==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): officeFrame=" + this.officeFrame.toString());
        }
        if (this.lastLoadingStatus == null) {
            System.out.println("OfficePanel: loadDocument(3): lastLoadingStatus==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): lastLoadingStatus=" + this.lastLoadingStatus.toString());
        }
    }

    public void dispose() {
        System.out.println("OfficePanel: dispose");
        if (this.officeFrame != null) {
            try {
                this.officeFrame.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.dispose();
    }

    public IStatus getLastLoadingStatus() {
        System.out.println("OfficePanel: getLastLoadingStatus");
        return this.lastLoadingStatus;
    }

    public void setLayout(Layout layout) {
        System.out.println("OfficePanel: setLayout(layout) - default action is to do nothing");
    }

    protected void documentLoadingOperationDone() {
        System.out.println("OfficePanel: documentLoadingOperationDone() - default action is to do nothing");
    }

    protected IProgressMonitor getProgressMonitor() {
        System.out.println("OfficePanel: getProgressMonitor()");
        if (this.progressMonitorPart != null) {
            return this.progressMonitorPart;
        }
        return new NullProgressMonitor();
    }

    protected IStatus startOfficeApplication(IOfficeApplication officeApplication) {
        System.out.println("OfficePanel: StartOfficeApplication(officeApplication)");
        if (officeApplication == null) {
            System.out.println("OfficePanel: StartOfficeApplication(1): WARNING: officeApplication==null");
        } else {
            System.out.println("OfficePanel: StartOfficeApplication(1): officeApplication=" + officeApplication.toString());
        }
        if (this.getShell() == null) {
            System.out.println("OfficePanel: StartOfficeApplication(1): WARNING: getShell()==null");
        } else {
            System.out.println("OfficePanel: StartOfficeApplication(1): getShell()=" + this.getShell().toString());
        }
        return NOAUIPlugin.startLocalOfficeApplication(this.getShell(), officeApplication);
    }

    protected void buildProgressIndicator(Composite parent) {
        System.out.println("OfficePanel: buildProgressIndicator()");
        this.progressComposite = new Composite(parent, 0x1000000);
        this.progressComposite.setBackground(Display.getCurrent().getSystemColor(16));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = -5;
        gridLayout.marginBottom = -5;
        gridLayout.marginRight = -5;
        this.progressComposite.setLayout((Layout)gridLayout);
        Composite composite = new Composite(this.progressComposite, 0x1000000);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(Display.getCurrent().getSystemColor(16));
        Composite progressIndicator = new Composite(this.progressComposite, 0x1000000);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.verticalAlignment = 0x1000000;
        progressIndicator.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        progressIndicator.setLayout((Layout)gridLayout);
        this.progressMonitorPart = new ProgressMonitorPart(progressIndicator, null);
        gridData = new GridData(4, 0, true, false);
        gridData.verticalAlignment = 0x1000000;
        this.progressMonitorPart.setLayoutData((Object)gridData);
        Link linkCancel = new Link(progressIndicator, 0x800000);
        linkCancel.setText("<a>" + Messages.OfficePanel_link_text_cancel + "</a>");
        this.progressMonitorPart.attachToCancelComponent((Control)linkCancel);
    }

    protected void showProgressIndicator() {
        System.out.println("OfficePanel: showProgressIndicator()");
        if (this.progressComposite == null) {
            this.buildProgressIndicator(this.baseComposite);
        }
        this.stackLayout.topControl = this.progressComposite;
        this.baseComposite.layout();
    }

    protected void hideProgressIndicator() {
        System.out.println("OfficePanel: hideProgressIndicator() - default action is to do nothing");
    }

    protected final IOfficeApplication getOfficeApplication() {
        System.out.println("OfficePanel: getOfficeApplication()");
        return this.officeApplication;
    }

    private void loadDocument(String documentPath, IDocumentDescriptor documentDescriptor, IProgressMonitor progressMonitor) throws CoreException {
        System.out.println("OfficePanel: loadDocument(documentPath, documentDescriptor, progressMonitor) begin");
        if (documentPath == null) {
            System.out.println("OfficePanel: loadDocument(3): WARNING: documentPath==null");
        } else {
            System.out.println("OfficePanel: loadDocument(3): documentPath=" + documentPath);
        }
        URL url = this.convertToURL(documentPath);
        System.out.println("OfficePanel: loadDocument(3): url=" + url.toString());
        try {
            System.out.println("OfficePanel: loadDocumen(3)t: trying to allocate new LoadDocumentOperation()...");
            LoadDocumentOperation loadDocumentOperation = new LoadDocumentOperation(null, this.getOfficeApplication(), this.officeFrame, url, documentDescriptor);
            if (loadDocumentOperation == null) {
                System.out.println("OfficePanel: loadDocument(3): WARNING: loadDocumentOperation==null");
            } else {
                System.out.println("OfficePanel: loadDocument(3): SUCCESS: loadDocumentOperation= " + loadDocumentOperation.toString());
            }
            System.out.println("OfficePanel: loadDocument(3): trying loadDocumentOperation.run(progressMonitor)...");
            loadDocumentOperation.run(progressMonitor);
            System.out.println("OfficePanel: loadDocument(3): trying document=loadDocumentOperation.getDocument()...");
            this.document = loadDocumentOperation.getDocument();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("OfficePanel: loadDocument(3): FAILURE: caught InvocationTargetException during loadDocumentOperation");
            this.documentLoadingOperationDone();
            throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, invocationTargetException.getCause().getMessage(), invocationTargetException.getCause()));
        }
        catch (InterruptedException interruptedException) {
            System.out.println("OfficePanel: loadDocument(3): FAILURE: caught InterruptedException during loadDocumentOperation");
        }
        System.out.println("OfficePanel: loadDocument(3): loadDocumentOperationDone()...");
        this.documentLoadingOperationDone();
        System.out.println("OfficePanel: loadDocument(3) end");
    }

    private void showOfficeFrame() {
        System.out.println("OfficePanel: showOfficeFrame(): begin");
        System.out.println("OfficePanel: showOfficeFrame(): baseComposite.isDisposed()=" + this.baseComposite.isDisposed());
        if (this.officeComposite == null) {
            System.out.println("OfficePanel: showOfficeFrame(): WARNING: officeComposite==null");
        } else {
            System.out.println("OfficePanel: showOfficeFrame(): officeComposite=" + this.officeComposite.toString());
        }
        if (!this.baseComposite.isDisposed()) {
            this.stackLayout.topControl = this.officeComposite;
            this.baseComposite.layout();
            this.officeComposite.layout();
            System.out.println("OfficePanel: showOfficeFrame(): end");
        }
    }

    private void buildControls() {
        System.out.println("OfficePanel: buildControls()");
        super.setLayout((Layout)new GridLayout());
        this.baseComposite = new Composite((Composite)this, 0x1000000);
        this.baseComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = -5;
        this.stackLayout.marginWidth = -5;
        this.baseComposite.setLayout((Layout)this.stackLayout);
        this.baseComposite.setBackground(this.getParent().getBackground());
        if (!this.showProgressIndicator) {
            this.buildProgressIndicator(this);
        }
    }

    private IFrame activateNewFrame() throws CoreException {
        System.out.println("OfficePanel: activateNewFrame()");
        Control oldOfficeComposite = this.stackLayout.topControl;
        Frame oldOfficeAWTFrame = this.officeAWTFrame;
        this.officeComposite = new Composite(this.baseComposite, 0x1000000);
        this.officeComposite.setBackground(this.getBackground());
        this.officeComposite.setLayout((Layout)new GridLayout());
        try {
            System.out.println("OfficePanel: activateNewFrame(): Trying...");
            this.officeAWTFrame = SWT_AWT.new_Frame((Composite)this.officeComposite);
            this.officeAWTFrame.setVisible(true);
            this.officeAWTFrame.setBackground(Color.GRAY);
            Panel officeAWTPanel = new Panel();
            officeAWTPanel.setLayout(new BorderLayout());
            officeAWTPanel.setVisible(true);
            this.officeAWTFrame.add(officeAWTPanel);
            if (!this.getOfficeApplication().isActive()) {
                System.out.println("OfficePanel: activateNewFrame(): !getOfficeApplication().isActive()...");
                System.out.println("OfficePanel: activateNewFrame(): startOfficeApplication(getOfficeApplication)...");
                IStatus status = this.startOfficeApplication(this.getOfficeApplication());
                if (status == null) {
                    System.out.println("OfficePanel: activateNewFrame(): resulting status==null");
                } else {
                    System.out.println("OfficePanel: activateNewFrame(): resulting status=" + status.toString());
                }
                if (status.getSeverity() == 4) {
                    System.out.println("OfficePanel: activateNewFrame(): WARNING: status.getSeverity()==IStatus.ERROR");
                    throw new CoreException(status);
                }
            }
            if (this.isDisposed()) {
                System.out.println("OfficePanel: activateNewFrame(): isDisposed() ... throwing");
                throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, "Widget disposed", null));
            }
            IFrame newOfficeFrame = this.getOfficeApplication().getDesktopService().constructNewOfficeFrame(this.officeAWTFrame);
            if (oldOfficeAWTFrame != null) {
                oldOfficeAWTFrame.dispose();
            }
            if (oldOfficeComposite != null) {
                oldOfficeComposite.dispose();
            }
            this.stackLayout.topControl = this.officeComposite;
            this.baseComposite.layout();
            if (newOfficeFrame == null) {
                System.out.println("OfficePanel: activateNewFrame(): WARNING: Returning newOfficeFrame==null");
            } else {
                System.out.println("OfficePanel: activateNewFrame(): Returning newOfficeFrame=" + newOfficeFrame.toString());
            }
            return newOfficeFrame;
        }
        catch (Throwable throwable) {
            System.out.println("OfficePanel: activateNewFrame(): CATCHING - SORRY...");
            throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, throwable.getMessage(), throwable));
        }
    }

    private URL convertToURL(String documentPath) throws CoreException {
        System.out.println("OfficePanel: convertToURL(documentPath) - modified by js re. Windows part");
        System.out.println("OfficePanel: convertToURL(1): TO DO: Please note that the correction-mod may not be necessary any more in noa4e 2.0.14 (js)");
        System.out.println("OfficePanel: convertToURL(1): Now trying conversion; if it succeeds, will return immediately thereafter.");
        try {
            System.out.println("OfficePanel: convertToURL(1): FRAGE: ****************************************************************************************");
            System.out.println("OfficePanel: convertToURL(1): FRAGE: M\u00fcssen eigentlich wirklich mehrfach im Verlauf mehrere / vorne eingef\u00fcgt werden?");
            System.out.println("OfficePanel: convertToURL(1): FRAGE: Die Zahl der f\u00fchrenden (Back)Slashes scheint n\u00e4mlich hier und sp\u00e4ter nochmal zu wachsen.");
            System.out.println("OfficePanel: convertToURL(1): FRAGE: Das mag ohne Auswirkungen bleiben - aber ist es notwendig?");
            System.out.println("OfficePanel: convertToURL(1): FRAGE: ****************************************************************************************");
            if (OSHelper.IS_WINDOWS) {
                System.out.println("OfficePanel: convertToURL(1): For " + OSHelper.OS_NAME + ": adding file:/// in front of documentPath");
                return new URL("file:///" + documentPath);
            }
            System.out.println("OfficePanel: convertToURL(1): For " + OSHelper.OS_NAME + ": adding file:// in front of documentPath");
            System.out.println("OfficePanel: convertToURL(1): In Linux scheint das zu funktionieren mit vorangestelltem:   file:////, file:////, file:///, file://");
            System.out.println("OfficePanel: convertToURL(1): In Linux scheint es aber NICHT zu gehen mit vorangestelltem: file:/");
            System.out.println("OfficePanel: convertToURL(1): Urspr\u00fcnglich im Code war f\u00fcr Linux:                          file:////");
            System.out.println("OfficePanel: convertToURL(1): Dabei bedeutet funktionieren: Nacher gibt's ein document!=null.");
            return new URL("file://" + documentPath);
        }
        catch (Throwable throwable) {
            System.out.println("OfficePanel: convertToURL(1): FAILURE - catching throwable.");
            throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, throwable.getMessage(), throwable));
        }
    }
}

