/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.internal.text;

import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextField;
import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.internal.text.Annotation;
import ag.ion.noa.text.IAnnotation;
import ag.ion.noa.text.IAnnotationService;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class AnnotationService
implements IAnnotationService {
    private ITextDocument textDocument = null;

    public AnnotationService(ITextDocument textDocument) {
        Assert.isNotNull(textDocument, XTextDocument.class, this);
        this.textDocument = textDocument;
    }

    @Override
    public IAnnotation[] getAnnotations() {
        try {
            ITextField[] fields = this.textDocument.getTextFieldService().getUserTextFields();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (int i = 0; i < fields.length; ++i) {
                XServiceInfo info = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)fields[i].getXTextContent());
                if (!info.supportsService("com.sun.star.text.TextField.Annotation")) continue;
                annotations.add(new Annotation(this.textDocument, fields[i]));
            }
            return annotations.toArray(new IAnnotation[annotations.size()]);
        }
        catch (Throwable throwable) {
            return new IAnnotation[0];
        }
    }
}

