/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.internal.script;

import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.internal.script.Script;
import ag.ion.noa.script.IScript;
import ag.ion.noa.script.IScriptProvider;
import com.sun.star.beans.XPropertySet;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.provider.XScript;
import com.sun.star.script.provider.XScriptProvider;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.List;

public class ScriptProvider
implements IScriptProvider {
    private XScriptProvider scriptProvider = null;

    public ScriptProvider(XScriptProvider xScriptProvider) {
        Assert.isNotNull(xScriptProvider, XScriptProvider.class, this);
        this.scriptProvider = xScriptProvider;
    }

    @Override
    public IScript getScript(String type, String library, String module, String name) {
        if (type == null || library == null || name == null) {
            return null;
        }
        boolean needsModule = type.equals("Basic");
        if (needsModule && module == null) {
            return null;
        }
        IScript[] allScripts = this.getScripts(type, library);
        for (int i = 0; i < allScripts.length; ++i) {
            IScript script = allScripts[i];
            String moduleName = script.getModuleName();
            if (!script.getName().equals(name)) continue;
            if (needsModule) {
                if (moduleName == null || !moduleName.equals(module)) continue;
                return script;
            }
            return script;
        }
        return null;
    }

    @Override
    public IScript[] getScripts(String type, String library) {
        if (type == null || library == null) {
            return IScript.EMPTY_ARRAY;
        }
        return this.getScriptsInternal(type, library);
    }

    @Override
    public IScript[] getScripts(String library) {
        if (library == null) {
            return IScript.EMPTY_ARRAY;
        }
        return this.getScriptsInternal(null, library);
    }

    @Override
    public IScript[] getScripts() {
        XBrowseNode rootNode = (XBrowseNode)UnoRuntime.queryInterface(XBrowseNode.class, (Object)this.scriptProvider);
        XBrowseNode[] typeNodes = rootNode.getChildNodes();
        ArrayList list = new ArrayList();
        for (XBrowseNode typeNode : typeNodes) {
            for (XBrowseNode libraryNode : typeNode.getChildNodes()) {
                this.buildScripts(list, libraryNode);
            }
        }
        return list.toArray(new IScript[list.size()]);
    }

    private IScript[] getScriptsInternal(String type, String library) {
        XBrowseNode rootNode = (XBrowseNode)UnoRuntime.queryInterface(XBrowseNode.class, (Object)this.scriptProvider);
        XBrowseNode[] typeNodes = rootNode.getChildNodes();
        ArrayList list = new ArrayList();
        for (XBrowseNode typeNode : typeNodes) {
            XBrowseNode libraryNode;
            if (type != null && !typeNode.getName().equals(type) || (libraryNode = this.getLibraryNode(typeNode, library)) == null) continue;
            this.buildScripts(list, libraryNode);
        }
        return list.toArray(new IScript[list.size()]);
    }

    private List buildScripts(List list, XBrowseNode browseNode) {
        XBrowseNode[] scriptNodes = browseNode.getChildNodes();
        if (list == null) {
            list = new ArrayList<Script>();
        }
        for (XBrowseNode scriptNode : scriptNodes) {
            if (scriptNode.getType() == 0) {
                XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)scriptNode);
                if (propertySet == null) continue;
                try {
                    Object object = propertySet.getPropertyValue("URI");
                    String uri = object.toString();
                    XScript xScript = this.scriptProvider.getScript(uri);
                    list.add(new Script(uri, xScript));
                }
                catch (Throwable throwable) {}
                continue;
            }
            this.buildScripts(list, scriptNode);
        }
        return list;
    }

    private XBrowseNode getLibraryNode(XBrowseNode typeNode, String library) {
        for (XBrowseNode libraryNode : typeNode.getChildNodes()) {
            if (!libraryNode.getName().equals(library)) continue;
            return libraryNode;
        }
        return null;
    }
}

