/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.util;

import ag.ion.bion.officelayer.internal.util.NumberFormat;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.util.INumberFormat;
import ag.ion.bion.officelayer.util.INumberFormatService;
import ag.ion.bion.officelayer.util.UtilException;
import ag.ion.noa.service.IServiceProvider;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.Locale;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatter;
import java.util.ArrayList;

public class NumberFormatService
implements INumberFormatService {
    private static final String STRING_TRUE = "true";
    private static final String INT_TRUE = "1";
    private static final String STRING_FALSE = "false";
    private static final String INT_FALSE = "0";
    private static final int[] ADDITIONAL_CURRENCY_KEYS = new int[0];
    private ITextDocument textDocument = null;
    private XNumberFormatsSupplier xNumberFormatsSupplier = null;
    private XNumberFormatter xNumberFormatter = null;

    public NumberFormatService(ITextDocument textDocument, XNumberFormatsSupplier xNumberFormatsSupplier) throws IllegalArgumentException {
        if (xNumberFormatsSupplier == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XNumberFormatsSupplier interface is not valid.");
        }
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        this.xNumberFormatsSupplier = xNumberFormatsSupplier;
        this.textDocument = textDocument;
    }

    @Override
    public XNumberFormatsSupplier getXNumberFormatsSupplier() {
        return this.xNumberFormatsSupplier;
    }

    @Override
    public INumberFormat getNumberFormat(int key) throws UtilException {
        INumberFormat[] allFormats = this.getNumberFormats();
        for (int i = 0; i < allFormats.length; ++i) {
            if (key != allFormats[i].getFormatKey()) continue;
            return allFormats[i];
        }
        try {
            XNumberFormats xNumberFormats = this.xNumberFormatsSupplier.getNumberFormats();
            XPropertySet docProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.textDocument.getXTextDocument());
            Locale docLocale = (Locale)docProps.getPropertyValue("CharLocale");
            XNumberFormatTypes numberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)xNumberFormats);
            int newKey = numberFormatTypes.getFormatForLocale(key, docLocale);
            for (int i = 0; i < allFormats.length; ++i) {
                if (newKey != allFormats[i].getFormatKey()) continue;
                return allFormats[i];
            }
        }
        catch (Exception exception) {
            UtilException utilException = new UtilException(exception.getMessage());
            utilException.initCause(exception);
            throw utilException;
        }
        throw new UtilException("The number format is not available.");
    }

    @Override
    public INumberFormat[] getNumberFormats() throws UtilException {
        return this.getNumberFormats((short)0);
    }

    @Override
    public INumberFormat[] getNumberFormats(short type) throws UtilException {
        try {
            XNumberFormats xNumberFormats = this.xNumberFormatsSupplier.getNumberFormats();
            XPropertySet docProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.textDocument.getXTextDocument());
            Locale docLocale = (Locale)docProps.getPropertyValue("CharLocale");
            int[] keys = xNumberFormats.queryKeys(type, docLocale, true);
            ArrayList<NumberFormat> formats = new ArrayList<NumberFormat>();
            boolean additionalCurrenciesSet = false;
            for (int i = 0; i < keys.length; ++i) {
                int key = keys[i];
                XPropertySet xProp = xNumberFormats.getByKey(key);
                if (((Short)xProp.getPropertyValue("Type")).equals(new Short(8)) && !additionalCurrenciesSet) {
                    for (int j = 0; j < ADDITIONAL_CURRENCY_KEYS.length; ++j) {
                        XPropertySet xPropAdd = xNumberFormats.getByKey(ADDITIONAL_CURRENCY_KEYS[j]);
                        formats.add(new NumberFormat(ADDITIONAL_CURRENCY_KEYS[j], xPropAdd, this));
                    }
                    additionalCurrenciesSet = true;
                }
                formats.add(new NumberFormat(key, xProp, this));
            }
            return formats.toArray(new INumberFormat[formats.size()]);
        }
        catch (Exception exception) {
            UtilException utilException = new UtilException(exception.getMessage());
            utilException.initCause(exception);
            throw utilException;
        }
    }

    @Override
    public double convertStringToNumber(int key, String text) throws UtilException {
        try {
            if (this.xNumberFormatter == null) {
                IServiceProvider serviceProvider = this.textDocument.getServiceProvider();
                if (serviceProvider == null) {
                    throw new UtilException("No service provider available in document.");
                }
                Object formatter = serviceProvider.createServiceWithContext("com.sun.star.util.NumberFormatter");
                this.xNumberFormatter = (XNumberFormatter)UnoRuntime.queryInterface(XNumberFormatter.class, (Object)formatter);
                this.xNumberFormatter.attachNumberFormatsSupplier(this.xNumberFormatsSupplier);
            }
            return this.xNumberFormatter.convertStringToNumber(key, text);
        }
        catch (Exception exception) {
            UtilException utilException = new UtilException(exception.getMessage());
            utilException.initCause(exception);
            throw utilException;
        }
    }

    @Override
    public String convertNumberToString(int key, double number) throws UtilException {
        try {
            if (this.xNumberFormatter == null) {
                IServiceProvider serviceProvider = this.textDocument.getServiceProvider();
                if (serviceProvider == null) {
                    throw new UtilException("No service provider available in document.");
                }
                Object formatter = serviceProvider.createServiceWithContext("com.sun.star.util.NumberFormatter");
                this.xNumberFormatter = (XNumberFormatter)UnoRuntime.queryInterface(XNumberFormatter.class, (Object)formatter);
                this.xNumberFormatter.attachNumberFormatsSupplier(this.xNumberFormatsSupplier);
            }
            return this.xNumberFormatter.convertNumberToString(key, number);
        }
        catch (Exception exception) {
            UtilException utilException = new UtilException(exception.getMessage());
            utilException.initCause(exception);
            throw utilException;
        }
    }

    @Override
    public String applyFormat(String text, INumberFormat numberFormat) throws UtilException {
        if (numberFormat == null || text == null) {
            return text;
        }
        short type = numberFormat.getFormatType();
        int key = numberFormat.getFormatKey();
        if (type == 256) {
            return text;
        }
        if (type == 16 || type == 128 || type == 8 || type == 9 || type == 2 || type == 4 || type == 6 || type == 32 || type == 64) {
            double number = this.convertStringToNumber(key, text);
            return this.convertNumberToString(key, number);
        }
        if (type == 1024) {
            if (text.equals(STRING_TRUE)) {
                text = INT_TRUE;
            } else if (text.equals(STRING_FALSE)) {
                text = INT_FALSE;
            }
            double number = this.convertStringToNumber(key, text);
            return this.convertNumberToString(key, number);
        }
        return text;
    }
}

