/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.internal.text.table.extended.ETextTable;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCell;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCell;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCellRange;
import ag.ion.bion.officelayer.text.table.extended.IETextTableRow;

public class ETextTableRow
implements IETextTableRow {
    private ITextDocument textDocument = null;
    private IETextTableCellRange textTableCellRange = null;
    private IETextTableCell[] textTableCells = null;

    public ETextTableRow(IETextTableCellRange textTableCellRange, int rowNumber, ETextTable textTable) throws IllegalArgumentException {
        if (textTableCellRange == null) {
            throw new IllegalArgumentException("Submitted range is not valid.");
        }
        if (textTable == null) {
            throw new IllegalArgumentException("The submitted table is not valid.");
        }
        this.textDocument = textTableCellRange.getTextDocument();
        this.textTableCellRange = textTableCellRange;
        IETextTableCell[] tableCells = textTableCellRange.getCells();
        this.textTableCells = new IETextTableCell[tableCells.length];
        for (int i = 0; i < tableCells.length; ++i) {
            this.textTableCells[i] = new ETextTableCell(tableCells[i].getTableCell(), TextTableCellNameHelper.getColumnCharacter(tableCells[i].getName().getName() + rowNumber), textTable);
        }
    }

    @Override
    public IETextTableCell[] getCells() {
        return this.textTableCells;
    }

    @Override
    public IETextTableCellRange getCellRange() {
        return this.textTableCellRange;
    }
}

