/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.beans.PropertyKeysContainer;
import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ClonedObject;
import ag.ion.bion.officelayer.clone.DestinationPosition;
import ag.ion.bion.officelayer.clone.IClonedObject;
import ag.ion.bion.officelayer.clone.IDestinationPosition;
import ag.ion.bion.officelayer.internal.clone.AbstractCloneService;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTable;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.extended.IETextTable;

public class ETextTableCloneService
extends AbstractCloneService {
    private ETextTable textTable = null;
    private ITextDocument textDocument = null;

    public ETextTableCloneService(IETextTable textTable, ITextDocument textDocument) throws CloneException {
        if (textTable == null) {
            throw new CloneException("The submitted table is not valid");
        }
        if (textDocument == null) {
            throw new CloneException("The submitted text document is not valid");
        }
        if (!(textTable instanceof ETextTable)) {
            throw new CloneException("The submitted table is not valid");
        }
        this.textTable = (ETextTable)textTable;
        this.textDocument = textDocument;
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(position, adoptContent, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, adoptContent, false, propertyKeysContainer);
    }

    private IClonedObject clonePreprocessor(IDestinationPosition position, boolean adoptContent, boolean generateReturnValue, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        ITextTable[] textTables = this.textTable.getTextTableManagement().getTextTables();
        ITextTable table = (ITextTable)textTables[0].getCloneService().cloneToPosition(position, adoptContent, propertyKeysContainer).getClonedObject();
        ETextTable eTextTable = new ETextTable(this.textDocument, table);
        for (int i = 1; i < textTables.length; ++i) {
            DestinationPosition destinationPosition = new DestinationPosition(table);
            table = (ITextTable)((Object)textTables[i].getCloneService().cloneToPosition(destinationPosition, propertyKeysContainer));
            try {
                eTextTable.addTable(table);
                continue;
            }
            catch (TextException textException) {
                CloneException cloneException = new CloneException("Error while cloning table");
                cloneException.initCause(textException);
                throw cloneException;
            }
        }
        if (generateReturnValue) {
            return new ClonedObject(eTextTable, eTextTable.getClass());
        }
        return null;
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, adoptContent, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, adoptContent, propertyKeysContainer);
    }
}

