/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.beans.PropertyKeysContainer;
import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ClonedObject;
import ag.ion.bion.officelayer.clone.DestinationPosition;
import ag.ion.bion.officelayer.clone.IClonedObject;
import ag.ion.bion.officelayer.clone.IDestinationPosition;
import ag.ion.bion.officelayer.internal.clone.AbstractCloneService;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellRangeName;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTable;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCellRange;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCellRange;

public class ETextTableCellRangeCloneService
extends AbstractCloneService {
    private ETextTableCellRange textTableCellRange = null;
    private ITextDocument textDocument = null;

    public ETextTableCellRangeCloneService(IETextTableCellRange textTableCellRange, ITextDocument textDocument) throws CloneException {
        if (textTableCellRange == null) {
            throw new CloneException("The submitted range is not valid");
        }
        if (!(textTableCellRange instanceof ETextTableCellRange)) {
            throw new CloneException("The submitted range is not valid");
        }
        if (textDocument == null) {
            throw new CloneException("The submitted text document is not valid");
        }
        this.textTableCellRange = (ETextTableCellRange)textTableCellRange;
        this.textDocument = textDocument;
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(position, adoptContent, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, adoptContent, false, propertyKeysContainer);
    }

    private IClonedObject clonePreprocessor(IDestinationPosition position, boolean adoptContent, boolean generateReturnValue, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        try {
            ITextTableCellRange[] textTableCellRanges = this.textTableCellRange.getRanges();
            ITextTableCellRange[] range = new ITextTableCellRange[textTableCellRanges.length];
            range[0] = (ITextTableCellRange)textTableCellRanges[0].getCloneService().cloneToPosition(position, adoptContent, propertyKeysContainer).getClonedObject();
            ITextTable table = range[0].getCell(0, 0).getTextTable();
            ETextTable eTextTable = new ETextTable(this.textDocument, table);
            for (int i = 1; i < textTableCellRanges.length; ++i) {
                DestinationPosition destinationPosition = new DestinationPosition(table);
                range[i] = (ITextTableCellRange)textTableCellRanges[i].getCloneService().cloneToPosition(destinationPosition, propertyKeysContainer).getClonedObject();
                table = range[i].getCell(0, 0).getTextTable();
                eTextTable.addTable(table);
            }
            if (generateReturnValue) {
                TextTableCellRangeName textTableCellRangeName = new TextTableCellRangeName(0, 0, range[0].getColumnCount() - 1, range[0].getRowCount());
                ETextTableCellRange cellRange = new ETextTableCellRange(range, textTableCellRangeName, eTextTable);
                return new ClonedObject(cellRange, cellRange.getClass());
            }
            return null;
        }
        catch (TextException textException) {
            CloneException cloneException = new CloneException("Error while cloning table");
            cloneException.initCause(textException);
            throw cloneException;
        }
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, adoptContent, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, adoptContent, propertyKeysContainer);
    }
}

