/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.beans.IPropertyStore;
import ag.ion.bion.officelayer.beans.PropertyKeysContainer;
import ag.ion.bion.officelayer.clone.CloneDestinationPosition;
import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ClonedObject;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.clone.IClonedObject;
import ag.ion.bion.officelayer.clone.IDestinationPosition;
import ag.ion.bion.officelayer.internal.clone.AbstractCloneService;
import ag.ion.bion.officelayer.internal.text.TextTableProperties;
import ag.ion.bion.officelayer.internal.text.table.TextTablePropertyStore;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.ITextContentService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableProperties;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTablePropertyStore;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;

public class TextTableCloneService
extends AbstractCloneService {
    private ITextTable textTable = null;
    private XTextDocument textDocument = null;
    private XMultiServiceFactory serviceFactory = null;
    private ICloneService[][] cellCloneServices = null;
    private ITextTablePropertyStore tablePropertyStore = null;

    public TextTableCloneService(ITextTable table, XTextDocument textDocument) throws CloneException {
        this.textTable = table;
        this.textDocument = textDocument;
        this.serviceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)textDocument);
        this.getTableInfo(table);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition range, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(range, true, false, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, true, false, false, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition range, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(range, adoptContent, false, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, adoptContent, false, false, propertyKeysContainer);
    }

    private IClonedObject clonePreprocessor(IDestinationPosition position, boolean adoptContent, boolean createSpace, boolean generateReturnValue, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        try {
            ITextRange range = null;
            if (position.getType() != null && ITextRange.class.isAssignableFrom(position.getType())) {
                range = (ITextRange)position.getDestinationObject();
            }
            ITextDocument textDocument = this.textTable.getTextDocument();
            ITextContentService textContentService = textDocument.getTextService().getTextContentService();
            ITextTable newTable = textDocument.getTextTableService().constructTextTable(this.tablePropertyStore.getRows(), this.tablePropertyStore.getColumns());
            if (range != null) {
                textContentService.insertTextContent(range, newTable);
            } else {
                textContentService.insertTextContentAfter(newTable, this.textTable);
            }
            String[] propertyKeysToCopy = null;
            propertyKeysToCopy = propertyKeysContainer != null ? propertyKeysContainer.getPropertyKeys("ag.ion.bion.officelayer.text.TextTableProperties") : TextTableProperties.getDefaultPropertyKeys();
            if (propertyKeysToCopy != null) {
                ITextTableProperties newTableProperties = newTable.getProperties();
                ((IPropertyStore)((Object)this.tablePropertyStore)).getProperties().copyTo(propertyKeysToCopy, newTableProperties);
            }
            int rowArrayLength = this.cellCloneServices.length;
            for (int rows = 0; rows < rowArrayLength; ++rows) {
                newTable.getRow(rows).setHeight(this.textTable.getRow(rows).getHeight());
                newTable.getRow(rows).setAutoHeight(this.textTable.getRow(rows).getAutoHeight());
                int columnArrayLength = this.cellCloneServices[rows].length;
                for (int columns = 0; columns < columnArrayLength; ++columns) {
                    ICloneService cellClone = this.cellCloneServices[rows][columns];
                    ITextTableCell textTableCell = newTable.getCell(columns, rows);
                    CloneDestinationPosition destinationCell = new CloneDestinationPosition(textTableCell, textTableCell.getClass());
                    cellClone.cloneToPositionNoReturn(destinationCell, adoptContent, propertyKeysContainer);
                }
            }
            if (createSpace) {
                IParagraph paragraph = textContentService.constructNewParagraph();
                textContentService.insertTextContentBefore(paragraph, newTable);
            }
            if (generateReturnValue) {
                return new ClonedObject(newTable, newTable.getClass());
            }
            return null;
        }
        catch (Exception exception) {
            CloneException cloneException = new CloneException(exception.getMessage());
            cloneException.initCause(exception);
            throw cloneException;
        }
    }

    private void getTableInfo(ITextTable textTable) throws CloneException {
        try {
            int rowCount = textTable.getRowCount();
            int columnCount = textTable.getColumnCount();
            this.tablePropertyStore = new TextTablePropertyStore(textTable);
            this.cellCloneServices = new ICloneService[rowCount][columnCount];
            for (int i = 0; i < rowCount; ++i) {
                for (int h = 0; h < columnCount; ++h) {
                    ITextTableCell currentTableCell = textTable.getCell(h, i);
                    this.cellCloneServices[i][h] = currentTableCell.getCloneService();
                }
            }
        }
        catch (TextException exception) {
            CloneException cloneException = new CloneException(exception.getMessage());
            cloneException.initCause(exception);
            throw cloneException;
        }
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(position, true, true, true, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, true, true, false, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(position, adoptContent, true, true, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, adoptContent, true, false, propertyKeysContainer);
    }
}

