/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.internal.text.table.TextTableCellReference;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaModel;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTableCellReferencesService;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;

public class TextTableCellReferencesService
implements ITextTableCellReferencesService {
    protected TextTableFormulaExpression textTableFormulaExpression = null;
    protected TextTableFormulaModel textTableFormulaModel = null;

    public TextTableCellReferencesService(TextTableFormulaExpression textTableFormulaExpression) throws IllegalArgumentException {
        if (textTableFormulaExpression == null) {
            throw new IllegalArgumentException("The submitted formula expression is not valid.");
        }
        this.textTableFormulaExpression = textTableFormulaExpression;
        this.textTableFormulaModel = new TextTableFormulaModel(textTableFormulaExpression);
    }

    @Override
    public boolean hasCellReferenceTo(String cellName) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !(value = textTableCellReference.containsCell(cellName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasColumnReferenceTo(int columnIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !(value = textTableCellReference.containsColumn(columnIndex))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasColumnReferenceAfter(int columnIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !(value = textTableCellReference.containsColumnAfter(columnIndex))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRowReferenceTo(int rowIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !(value = textTableCellReference.containsRow(rowIndex))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRowReferenceAfter(int rowIndex) {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            boolean value;
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !(value = textTableCellReference.containsRowAfter(rowIndex))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveColumnReferences(int columnCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified()) continue;
            textTableCellReference.moveColumnIndex(columnCount);
        }
    }

    @Override
    public void moveColumnReferences(String cellName, int columnCount) throws TextException {
        this.moveColumnReferences(TextTableCellNameHelper.getColumnIndex(cellName), columnCount);
    }

    @Override
    public void moveColumnReferences(int columnIndex, int columnCount) throws TextException {
        this.moveColumnReferences(columnIndex, columnCount, new int[0]);
    }

    @Override
    public void moveColumnReferences(int columnIndex, int columnCount, int[] exceptRows) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsColumn(columnIndex)) continue;
            boolean except = false;
            for (int j = 0; j < exceptRows.length; ++j) {
                if (!textTableCellReference.containsRow(exceptRows[j])) continue;
                except = true;
                break;
            }
            if (except) continue;
            textTableCellReference.moveColumnIndex(columnCount);
        }
    }

    @Override
    public void moveRowReferences(int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified()) continue;
            textTableCellReference.moveRowIndex(rowCount);
        }
    }

    @Override
    public void moveRowReferences(String cellName, int rowCount) throws TextException {
        this.moveRowReferences(TextTableCellNameHelper.getRowIndex(cellName), rowCount);
    }

    @Override
    public void moveRowReferences(int rowIndex, int rowCount) throws TextException {
        this.moveRowReferences(rowIndex, rowCount, new int[0]);
    }

    @Override
    public void moveRowReferences(int rowIndex, int rowCount, int[] exceptCols) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsRow(rowIndex)) continue;
            boolean except = false;
            for (int j = 0; j < exceptCols.length; ++j) {
                if (!textTableCellReference.containsColumn(exceptCols[j])) continue;
                except = true;
                break;
            }
            if (except) continue;
            textTableCellReference.moveRowIndex(rowCount);
        }
    }

    @Override
    public void moveColumnReferencesAfter(int columnIndex, int columnCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsColumnAfter(columnIndex)) continue;
            textTableCellReference.moveColumnIndex(columnCount);
        }
    }

    @Override
    public void moveRowReferencesAfter(int rowIndex, int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsRowAfter(rowIndex)) continue;
            textTableCellReference.moveRowIndex(rowCount);
        }
    }

    @Override
    public void extendColumnReferences(String cellName, int columnCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsColumn(cellName)) continue;
            textTableCellReference.extendColumnRange(columnCount);
        }
    }

    @Override
    public void extendColumnReferences(int columnIndex, int columnCount) throws TextException {
        this.extendColumnReferences(columnIndex, columnCount, new int[0]);
    }

    @Override
    public void extendColumnReferences(int columnIndex, int columnCount, int[] exceptRows) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsColumn(columnIndex)) continue;
            boolean except = false;
            for (int j = 0; j < exceptRows.length; ++j) {
                if (!textTableCellReference.containsRow(exceptRows[j])) continue;
                except = true;
                break;
            }
            if (except) continue;
            textTableCellReference.extendColumnRange(columnCount);
        }
    }

    @Override
    public void extendRowReferences(String cellName, int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsRow(cellName)) continue;
            textTableCellReference.extendRowRange(rowCount);
        }
    }

    @Override
    public void extendRowReferences(int rowIndex, int rowCount) throws TextException {
        this.extendRowReferences(rowIndex, rowCount, new int[0]);
    }

    @Override
    public void extendRowReferences(int rowIndex, int rowCount, int[] exceptCols) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsRow(rowIndex)) continue;
            boolean except = false;
            for (int j = 0; j < exceptCols.length; ++j) {
                if (!textTableCellReference.containsColumn(exceptCols[j])) continue;
                except = true;
                break;
            }
            if (except) continue;
            textTableCellReference.extendRowRange(rowCount);
        }
    }

    @Override
    public void extendRowReferencesTo(int rowIndex, int rowIndexTo) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsRow(rowIndex)) continue;
            textTableCellReference.extendRowRangeTo(rowIndexTo);
        }
    }

    @Override
    public void extendRowReferences(int rowIndex, int[] rowIndicesTo) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsRow(rowIndex) || textTableCellReference.isRangeReference()) continue;
            String startColumnCharacter = textTableCellReference.getStartColumnCharacter();
            TextTableCellReference[] tmpTextTableCellReferences = new TextTableCellReference[rowIndicesTo.length];
            for (int j = 0; j < rowIndicesTo.length; ++j) {
                tmpTextTableCellReferences[j] = new TextTableCellReference(startColumnCharacter + (rowIndicesTo[j] + 1));
            }
            this.textTableFormulaModel.replaceCellReference(textTableCellReference, tmpTextTableCellReferences);
        }
    }

    @Override
    public void revertModelToOriginal() {
        this.textTableFormulaModel.revertToOriginal();
    }

    @Override
    public void extendColumnAndRowReferences(String cellName, int columnCount, int rowCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.isModified() || !textTableCellReference.containsCell(cellName)) continue;
            textTableCellReference.extendColumnRange(columnCount);
            textTableCellReference.extendRowRange(rowCount);
        }
    }

    @Override
    public void modifyCellReferences(int newColumnsStartIndex, int newColumnsCount, int newRowsStartIndex, int newRowsCount) throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        for (int i = 0; i < textTableCellReferences.length; ++i) {
            TextTableCellReference textTableCellReference = textTableCellReferences[i];
            if (textTableCellReference.containsColumn(newColumnsStartIndex - 1)) {
                textTableCellReference.extendColumnRange(newColumnsCount);
            } else if (textTableCellReference.containsColumnAfter(newColumnsStartIndex - 1)) {
                textTableCellReference.moveColumnIndex(newColumnsCount);
            }
            if (textTableCellReference.containsRow(newRowsStartIndex - 1)) {
                textTableCellReference.extendRowRange(newRowsCount);
                continue;
            }
            if (!textTableCellReference.containsRowAfter(newRowsStartIndex - 1)) continue;
            textTableCellReference.moveRowIndex(newRowsCount);
        }
    }

    @Override
    public void applyModifications() throws TextException {
        this.textTableFormulaExpression.setExpression(this.textTableFormulaModel.getExpression());
    }
}

