/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.beans.IProperties;
import ag.ion.bion.officelayer.beans.IPropertyStore;
import ag.ion.bion.officelayer.beans.PropertyKeysContainer;
import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ClonedObject;
import ag.ion.bion.officelayer.clone.IClonedObject;
import ag.ion.bion.officelayer.clone.IDestinationPosition;
import ag.ion.bion.officelayer.internal.clone.AbstractCloneService;
import ag.ion.bion.officelayer.internal.text.CharacterProperties;
import ag.ion.bion.officelayer.internal.text.TextTable;
import ag.ion.bion.officelayer.internal.text.TextTableCellProperties;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellRangeCloneService;
import ag.ion.bion.officelayer.text.ICharacterPropertyStore;
import ag.ion.bion.officelayer.text.IText;
import ag.ion.bion.officelayer.text.ITextField;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellName;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.IFormula;
import ag.ion.bion.officelayer.text.table.IFormulaService;
import ag.ion.bion.officelayer.text.table.ITextTableCellPropertyStore;

public class TextTableCellCloneService
extends AbstractCloneService {
    private String cellValue = null;
    private String cellFormula = null;
    private int verticalPosition = -1;
    private int horizontalPosition = -1;
    private ITextTableCell cellToClone = null;
    private ITextTableCellPropertyStore cellPropertyStore = null;
    private ICharacterPropertyStore firstCellCharacterPropertyStore = null;
    private ITextTable parentTable = null;
    private String cellName = null;
    private ITextTableCellName textTableCellName = null;
    private ITextTableCellRange textTableCellRange = null;
    private TextTableCellRangeCloneService rangeCloneService = null;

    public TextTableCellCloneService(ITextTableCell cell) throws CloneException {
        this.cellToClone = cell;
        this.analyseCell(cell);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneToPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.clonePreprocessor(position, adoptContent, true, propertyKeysContainer);
    }

    @Override
    public void cloneToPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.clonePreprocessor(position, adoptContent, false, propertyKeysContainer);
    }

    private IClonedObject clonePreprocessor(IDestinationPosition position, boolean adoptContent, boolean generateReturnValue, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        if (position.getType() != null && ITextTableCell.class.isAssignableFrom(position.getType())) {
            ITextTableCell cell = (ITextTableCell)position.getDestinationObject();
            return this.recreateCell(cell, adoptContent, generateReturnValue, propertyKeysContainer);
        }
        if (ITextRange.class.isAssignableFrom(position.getType())) {
            try {
                if (this.textTableCellRange == null) {
                    if (this.parentTable == null) {
                        this.parentTable = this.cellToClone.getTextTable();
                    }
                    if (this.textTableCellName == null) {
                        this.textTableCellName = this.cellToClone.getName();
                    }
                    if (this.cellName == null) {
                        this.cellName = this.textTableCellName.getName();
                    }
                    this.textTableCellRange = this.parentTable.getCellRange(this.cellName + ":" + this.cellName);
                }
                if (this.rangeCloneService == null) {
                    this.rangeCloneService = new TextTableCellRangeCloneService(this.textTableCellRange);
                }
                if (generateReturnValue) {
                    return this.rangeCloneService.cloneToPosition(position, adoptContent, propertyKeysContainer);
                }
                this.rangeCloneService.cloneToPositionNoReturn(position, adoptContent, propertyKeysContainer);
                return null;
            }
            catch (TextException exception) {
                CloneException cloneException = new CloneException(exception.getMessage());
                cloneException.initCause(exception);
                throw cloneException;
            }
        }
        CloneException cloneException = new CloneException("Error cloning cell. No target selected or another error occred.");
        throw cloneException;
    }

    public String getCellValue() {
        return this.cellValue;
    }

    public void setCellValue(String cellValue) {
        this.cellValue = cellValue;
    }

    public String getCellFormula() {
        return this.cellFormula;
    }

    public void setCellFormula(String cellFormula) {
        this.cellFormula = cellFormula;
    }

    private void analyseCell(ITextTableCell cell) throws CloneException {
        try {
            IFormula formula;
            IFormulaService formulaService;
            IText text = cell.getTextService().getText();
            ITextField[] fields = text.getTextContentEnumeration().getTextFields();
            String textCell = text.getText();
            if (textCell != null) {
                for (int i = 0; i < fields.length; ++i) {
                    String displayText = fields[i].getDisplayText();
                    if (displayText == null) continue;
                    displayText = displayText.replaceAll("\\[", "\\\\[");
                    displayText = displayText.replaceAll("\\]", "\\\\]");
                    textCell = textCell.replaceAll(displayText, "");
                }
                if (textCell.length() > 0) {
                    this.cellValue = textCell;
                }
            }
            if (fields.length == 0 && (formulaService = cell.getFormulaService()) != null && (formula = formulaService.getFormula()) != null) {
                this.cellFormula = formula.getExpression();
            }
            this.cellPropertyStore = cell.getCellPropertyStore(0, 0);
            this.firstCellCharacterPropertyStore = cell.getCharacterPropertyStore();
        }
        catch (TextException excep) {
            CloneException cloneException = new CloneException(excep.getMessage());
            cloneException.initCause(excep);
            throw cloneException;
        }
    }

    private void getCellFromStore(TextTable table, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        try {
            if (this.textTableCellName == null) {
                this.textTableCellName = this.cellToClone.getName();
            }
            if (this.verticalPosition == -1) {
                this.verticalPosition = this.textTableCellName.getColumnIndex();
            }
            if (this.horizontalPosition == -1) {
                this.horizontalPosition = this.textTableCellName.getRowIndex();
            }
            if (this.cellPropertyStore != null && this.verticalPosition != -1 && this.horizontalPosition != -1) {
                ITextTableCell tableCell = table.getCell(this.verticalPosition, this.horizontalPosition);
                this.recreateCell(tableCell, adoptContent, false, propertyKeysContainer);
            }
        }
        catch (Exception exception) {
            CloneException cloneException = new CloneException(exception.getMessage());
            cloneException.initCause(exception);
            throw cloneException;
        }
    }

    private IClonedObject recreateCell(ITextTableCell tableCell, boolean adoptContent, boolean generateReturnValue, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        try {
            IProperties newProperties;
            if (adoptContent) {
                IText cellText;
                String cellTextString;
                if (this.cellFormula != null) {
                    tableCell.getFormulaService().setFormula(this.cellFormula);
                } else if (this.cellValue != null && ((cellTextString = (cellText = tableCell.getTextService().getText()).getText()) == null || cellTextString.length() == 0)) {
                    cellText.setText(this.cellValue);
                }
            }
            String[] propertyKeysToCopy = null;
            propertyKeysToCopy = propertyKeysContainer != null ? propertyKeysContainer.getPropertyKeys("ag.ion.bion.officelayer.text.TextTableCellProperties") : TextTableCellProperties.getDefaultPropertyKeys();
            if (propertyKeysToCopy != null) {
                newProperties = tableCell.getProperties();
                ((IPropertyStore)((Object)this.cellPropertyStore)).getProperties().copyTo(propertyKeysToCopy, newProperties);
            }
            propertyKeysToCopy = null;
            propertyKeysToCopy = propertyKeysContainer != null ? propertyKeysContainer.getPropertyKeys("ag.ion.bion.officelayer.text.CharacterProperties") : CharacterProperties.getDefaultPropertyKeys();
            if (propertyKeysToCopy != null) {
                newProperties = tableCell.getCharacterProperties();
                ((IPropertyStore)((Object)this.firstCellCharacterPropertyStore)).getProperties().copyTo(propertyKeysToCopy, newProperties);
            }
            if (generateReturnValue) {
                return new ClonedObject(tableCell, tableCell.getClass());
            }
            return null;
        }
        catch (Exception excep) {
            CloneException cloneException = new CloneException(excep.getMessage());
            cloneException.initCause(excep);
            throw cloneException;
        }
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, true, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, true, propertyKeysContainer);
    }

    @Override
    public IClonedObject cloneAfterThisPosition(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        return this.cloneToPosition(position, adoptContent, propertyKeysContainer);
    }

    @Override
    public void cloneAfterThisPositionNoReturn(IDestinationPosition position, boolean adoptContent, PropertyKeysContainer propertyKeysContainer) throws CloneException {
        this.cloneToPositionNoReturn(position, adoptContent, propertyKeysContainer);
    }
}

