/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.internal.text.table.Argument;
import ag.ion.bion.officelayer.internal.text.table.Arguments;
import ag.ion.bion.officelayer.internal.text.table.CalculateString;
import ag.ion.bion.officelayer.internal.text.table.ITextTableFormulaElement;
import ag.ion.bion.officelayer.text.TextException;
import java.util.ArrayList;

public class CalculateFormula {
    public static double calculate(ITextTableFormulaElement[] elements, Arguments arguments, String formula) throws TextException {
        double result = 0.0;
        CalculateString calculateString = new CalculateString();
        if (formula.length() == 0) {
            return result;
        }
        if (elements.length == 0) {
            result = calculateString.calculate(formula, arguments);
        } else {
            int count = 0;
            String calcString = formula;
            for (int i = 0; i < elements.length; ++i) {
                ITextTableFormulaElement element = elements[i];
                double help = element.calculate();
                String helpString = element.getFormula();
                int index = calcString.indexOf(helpString);
                calcString = calcString.substring(0, index) + "<HELP" + count + ">" + calcString.substring(index + helpString.length());
                Argument helpArgument = new Argument("<HELP" + count + ">");
                helpArgument.setValue(new Double(help));
                arguments.addArgument(helpArgument);
                ++count;
            }
            result = calculateString.calculate(calcString, arguments);
        }
        return result;
    }

    public static double calculate(ArrayList toCalc) throws TextException {
        if (toCalc == null) {
            return 0.0;
        }
        if (toCalc.size() == 0) {
            return 0.0;
        }
        double result = 0.0;
        double help = 0.0;
        CalculateFormula.calcPow(toCalc);
        CalculateFormula.calcFirst(toCalc);
        if (toCalc.get(0) instanceof Argument) {
            Argument first = (Argument)toCalc.get(0);
            result = first.getValue();
        }
        int n = toCalc.size();
        for (int i = 0; i < n; ++i) {
            if (toCalc.get(i) instanceof Argument || i >= toCalc.size() - 1) continue;
            String operator = toCalc.get(i).toString();
            if (toCalc.get(i + 1) instanceof Argument) {
                Argument argument = (Argument)toCalc.get(i + 1);
                help = argument.getValue();
            } else if (toCalc.get(i + 1).toString().equals("PI")) {
                help = Math.PI;
            } else if (toCalc.get(i + 1).toString().equals("E")) {
                help = Math.E;
            }
            if (operator.equals("+")) {
                result += help;
                continue;
            }
            if (operator.equals("-")) {
                result -= help;
                continue;
            }
            if (!operator.equals("round")) continue;
            result = CalculateFormula.roundOK(result, help);
        }
        return result;
    }

    private static double percent(double value) {
        return value / 100.0;
    }

    private static double sqrt(double value) {
        return Math.sqrt(value);
    }

    private static double pow(double firstValue, double secondValue) {
        return Math.pow(firstValue, secondValue);
    }

    private static double roundOK(double valueLeft, double valueRight) {
        double result = 0.0;
        valueRight = Math.floor(valueRight);
        result = valueLeft > 0.0 ? valueLeft * Math.pow(10.0, valueRight) + 0.5 : valueLeft * Math.pow(10.0, valueRight) - 0.5;
        result = Math.floor(result);
        return result /= Math.pow(10.0, valueRight);
    }

    private static void calcFirst(ArrayList toCalc) {
        for (int i = 0; i < toCalc.size(); ++i) {
            if ((toCalc.get(i) instanceof Argument || i <= 0 || i >= toCalc.size() - 1) && !toCalc.get(i).toString().equals("sqrt")) continue;
            String operator = toCalc.get(i).toString();
            CalculateFormula.calc(toCalc, operator, i);
        }
    }

    private static void calcPow(ArrayList toCalc) {
        for (int i = 0; i < toCalc.size(); ++i) {
            if (i <= 0 || !toCalc.get(i).toString().equals("pow")) continue;
            String operator = toCalc.get(i).toString();
            CalculateFormula.calc(toCalc, operator, i);
        }
    }

    private static void calc(ArrayList toCalc, String operator, int i) {
        double firstValue = 0.0;
        double secondValue = 0.0;
        int count = 0;
        Argument argument = null;
        if (!toCalc.get(i).toString().equals("sqrt")) {
            if (toCalc.get(i - 1) instanceof Argument) {
                Argument first = (Argument)toCalc.get(i - 1);
                firstValue = first.getValue();
            } else if (operator.equals("PI")) {
                firstValue = Math.PI;
            } else if (operator.equals("E")) {
                firstValue = Math.E;
            }
        }
        if (toCalc.get(i + 1) instanceof Argument) {
            argument = (Argument)toCalc.get(i + 1);
            secondValue = argument.getValue();
        } else if (operator.equals("PI")) {
            secondValue = Math.PI;
        } else if (operator.equals("E")) {
            secondValue = Math.E;
        }
        double result = 0.0;
        if (operator.equals("*")) {
            result = firstValue * secondValue;
        } else if (operator.equals("/")) {
            result = firstValue / secondValue;
        } else if (operator.equals("phd")) {
            result = CalculateFormula.percent(firstValue);
        } else if (operator.equals("sqrt")) {
            result = CalculateFormula.sqrt(secondValue);
        } else if (operator.equals("pow")) {
            result = CalculateFormula.pow(firstValue, secondValue);
        }
        if (operator.equals("*") || operator.equals("/") || operator.equals("phd") || operator.equals("sqrt") || operator.equals("pow")) {
            if (!operator.equals("sqrt")) {
                toCalc.remove(i - 1);
            } else {
                toCalc.remove(i);
            }
            if (!operator.equals("phd") && !operator.equals("sqrt")) {
                toCalc.remove(i - 1);
            }
            argument = new Argument("help" + count);
            argument.setValue(new Double(result));
            if (!operator.equals("sqrt")) {
                toCalc.set(i - 1, argument);
            } else {
                toCalc.set(i, argument);
            }
            ++count;
            --i;
        }
    }
}

