/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.TextTable;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableService;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;

public class TextTableService
implements ITextTableService {
    private ITextDocument textDocument = null;

    public TextTableService(ITextDocument textDocument) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        this.textDocument = textDocument;
    }

    @Override
    public ITextTable constructTextTable(int rows, int columns) throws TextException {
        if (columns > 52) {
            throw new TextException("The submitted table is not valid");
        }
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.textDocument.getXTextDocument());
            Object newTable = xMultiServiceFactory.createInstance("com.sun.star.text.TextTable");
            XTextTable newTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)newTable);
            newTextTable.initialize(rows, columns);
            TextTable textTable = new TextTable(this.textDocument, newTextTable);
            return textTable;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextTable[] getTextTables() {
        XTextTablesSupplier xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)this.textDocument.getXTextDocument());
        XNameAccess xNameAccess = xTextTablesSupplier.getTextTables();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess);
        ITextTable[] textTables = new ITextTable[xIndexAccess.getCount()];
        int n = xIndexAccess.getCount();
        for (int i = 0; i < n; ++i) {
            try {
                Any any = (Any)xIndexAccess.getByIndex(i);
                XTextTable textTable = (XTextTable)any.getObject();
                if (textTable.getColumns().getCount() > 52) continue;
                textTables[i] = new TextTable(this.textDocument, textTable);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return textTables;
    }

    @Override
    public ITextTable getTextTable(String name) throws TextException {
        try {
            XTextTablesSupplier xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)this.textDocument.getXTextDocument());
            XNameAccess xNameAccess = xTextTablesSupplier.getTextTables();
            Any any = (Any)xNameAccess.getByName(name);
            XTextTable textTable = (XTextTable)any.getObject();
            if (textTable.getColumns().getCount() <= 52) {
                return new TextTable(this.textDocument, textTable);
            }
            throw new TextException("The submitted table is not valid");
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }
}

