/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.beans.IPropertyKey;
import ag.ion.bion.officelayer.internal.beans.AbstractProperties;
import ag.ion.bion.officelayer.internal.beans.PropertyKey;
import ag.ion.bion.officelayer.internal.text.TextTableColumnsSeparator;
import ag.ion.bion.officelayer.text.ITextTableProperties;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.text.TableColumnSeparator;

public class TextTableProperties
extends AbstractProperties
implements ITextTableProperties {
    private long width = 0L;
    private static String[] DEFAULT_PROPERTY_KEYS = null;
    private static PropertyKey[] PROPERTY_KEYS = null;

    public TextTableProperties(XPropertySet xPropertySet) throws IllegalArgumentException {
        super(xPropertySet);
    }

    public static IPropertyKey[] getPossiblyPropertyKeys() {
        if (PROPERTY_KEYS == null) {
            PROPERTY_KEYS = new PropertyKey[]{new PropertyKey("RepeatHeadline", null, null), new PropertyKey("TableColumnSeparators", null, null), new PropertyKey("TableColumnRelativeSum", null, null), new PropertyKey("BreakType", null, null), new PropertyKey("LeftMargin", null, null), new PropertyKey("RightMargin", null, null), new PropertyKey("TopMargin", null, null), new PropertyKey("BottomMargin", null, null), new PropertyKey("HoriOrient", null, null), new PropertyKey("ShadowFormat", null, null), new PropertyKey("TableBorder", null, null), new PropertyKey("BackColor", null, null)};
        }
        return PROPERTY_KEYS;
    }

    public static String[] getDefaultPropertyKeys() {
        if (DEFAULT_PROPERTY_KEYS == null) {
            DEFAULT_PROPERTY_KEYS = new String[]{"RepeatHeadline", "TableColumnSeparators", "BreakType", "LeftMargin", "RightMargin", "TopMargin", "BottomMargin", "HoriOrient", "ShadowFormat", "TableBorder", "BackColor"};
        }
        return DEFAULT_PROPERTY_KEYS;
    }

    @Override
    public String getTypeID() {
        return "ag.ion.bion.officelayer.text.TextTableProperties";
    }

    @Override
    public void setRepeatHeadline(boolean repeatHeadline) throws TextException {
        try {
            this.getXPropertySet().setPropertyValue("RepeatHeadline", (Object)new Boolean(repeatHeadline));
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public boolean repeatHeadline() throws TextException {
        try {
            return (Boolean)this.getXPropertySet().getPropertyValue("RepeatHeadline");
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public int[] getCellWidths() throws TextException {
        int[] widths = null;
        try {
            TableColumnSeparator[] columnSeparator = (TableColumnSeparator[])this.getXPropertySet().getPropertyValue("TableColumnSeparators");
            widths = new int[columnSeparator.length + 1];
            widths[0] = columnSeparator[0].Position;
            for (int i = 1; i < columnSeparator.length; ++i) {
                widths[i] = columnSeparator[i].Position - columnSeparator[i - 1].Position;
            }
            widths[columnSeparator.length] = (int)(this.width - (long)columnSeparator[columnSeparator.length - 1].Position);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
        return widths;
    }

    @Override
    public long getWidth() throws TextException {
        try {
            this.width = new Long(this.getXPropertySet().getPropertyValue("TableColumnRelativeSum").toString());
            return this.width;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public TextTableColumnsSeparator[] getTableColumnSeparators() throws TextException {
        try {
            TableColumnSeparator[] tableColumnSeparators = (TableColumnSeparator[])this.getXPropertySet().getPropertyValue("TableColumnSeparators");
            TextTableColumnsSeparator[] textTableColumnsSeparators = new TextTableColumnsSeparator[tableColumnSeparators.length];
            for (int i = 0; i < tableColumnSeparators.length; ++i) {
                textTableColumnsSeparators[i] = new TextTableColumnsSeparator(tableColumnSeparators[i]);
            }
            return textTableColumnsSeparators;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setTableColumnSeparators(TextTableColumnsSeparator[] textTableColumnSeparators) throws TextException {
        try {
            TableColumnSeparator[] tableColumnSeparators = new TableColumnSeparator[textTableColumnSeparators.length];
            for (int i = 0; i < textTableColumnSeparators.length; ++i) {
                TableColumnSeparator tableColumnSeparator = new TableColumnSeparator();
                tableColumnSeparator.Position = textTableColumnSeparators[i].getPosition();
                tableColumnSeparator.IsVisible = textTableColumnSeparators[i].getIsVisible();
                tableColumnSeparators[i] = tableColumnSeparator;
            }
            this.getXPropertySet().setPropertyValue("TableColumnSeparators", (Object)tableColumnSeparators);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }
}

