/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.text.ITextTableCellName;

public class TextTableCellName
implements ITextTableCellName {
    private String cellName = null;

    public TextTableCellName(String cellName) throws IllegalArgumentException {
        if (cellName == null) {
            throw new IllegalArgumentException("The submitted cell name is not valid.");
        }
        if (cellName.startsWith("<")) {
            cellName = cellName.substring(1);
        }
        if (cellName.endsWith(">")) {
            cellName = cellName.substring(0, cellName.length() - 1);
        }
        this.cellName = cellName;
    }

    @Override
    public String getName() {
        return this.cellName;
    }

    @Override
    public int getRowIndex() {
        char[] chars = this.cellName.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            stringBuffer.append(chars[i]);
        }
        try {
            return Integer.parseInt(stringBuffer.toString()) - 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public int getColumnIndex() {
        char[] chars = this.cellName.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < chars.length && !Character.isDigit(chars[i]); ++i) {
            stringBuffer.append(chars[i]);
        }
        if (stringBuffer.length() == 1) {
            char character = stringBuffer.charAt(0);
            if (character < 'a') {
                return character - 65;
            }
            return character - 71;
        }
        char firstCharacter = stringBuffer.charAt(0);
        char secondCharacter = stringBuffer.charAt(1);
        int index = (firstCharacter - 64) * 50;
        index = secondCharacter < 'a' ? (index += secondCharacter - 65) : (index += secondCharacter - 71);
        return index;
    }
}

