/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.internal.text.Paragraph;
import ag.ion.bion.officelayer.internal.text.TextDocumentImage;
import ag.ion.bion.officelayer.internal.text.TextDocumentTextShape;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.ITextContent;
import ag.ion.bion.officelayer.text.ITextContentService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextDocumentImage;
import ag.ion.bion.officelayer.text.ITextDocumentTextShape;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.noa.graphic.GraphicInfo;
import ag.ion.noa.graphic.TextInfo;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XRelativeTextContentInsert;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TextContentService
implements ITextContentService {
    private ITextDocument textDocument = null;
    private XText xText = null;
    private XMultiServiceFactory xMultiServiceFactory = null;
    private XNameContainer xBitmapContainer = null;
    private XNameContainer xTextShapeContainer = null;
    private Map<ITextDocumentImage, String> imageToImageIds = null;
    private Map<ITextDocumentTextShape, String> textShapeToTextShapeIds = null;

    public TextContentService(ITextDocument textDocument, XMultiServiceFactory xMultiServiceFactory, XText xText) throws IllegalArgumentException {
        if (xText == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XText interface is not valid.");
        }
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        if (xMultiServiceFactory == null) {
            throw new IllegalArgumentException("Submitted multi service factory is not valid.");
        }
        this.xText = xText;
        this.xMultiServiceFactory = xMultiServiceFactory;
        this.textDocument = textDocument;
    }

    @Override
    public IParagraph constructNewParagraph() throws TextException {
        try {
            if (this.xMultiServiceFactory == null) {
                throw new TextException("OpenOffice.org XMultiServiceFactory inteface not valid.");
            }
            Object object = this.xMultiServiceFactory.createInstance("com.sun.star.text.Paragraph");
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
            return new Paragraph(this.textDocument, xTextContent);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextDocumentImage constructNewImage(GraphicInfo graphicInfo) throws TextException {
        try {
            if (this.xMultiServiceFactory == null) {
                throw new TextException("OpenOffice.org XMultiServiceFactory inteface not valid.");
            }
            if (this.xBitmapContainer == null) {
                this.xBitmapContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.xMultiServiceFactory.createInstance("com.sun.star.drawing.BitmapTable"));
            }
            XTextContent xImage = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)this.xMultiServiceFactory.createInstance("com.sun.star.text.TextGraphicObject"));
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xImage);
            String tempId = "tempImageId" + System.currentTimeMillis();
            this.xBitmapContainer.insertByName(tempId, (Object)graphicInfo.getUrl());
            String internalURL = AnyConverter.toString((Object)this.xBitmapContainer.getByName(tempId));
            xProps.setPropertyValue("AnchorType", (Object)graphicInfo.getAnchor());
            xProps.setPropertyValue("GraphicURL", (Object)internalURL);
            xProps.setPropertyValue("Width", (Object)graphicInfo.getWidth());
            xProps.setPropertyValue("Height", (Object)graphicInfo.getHeight());
            xProps.setPropertyValue("HoriOrient", (Object)graphicInfo.getHorizontalAlignment());
            xProps.setPropertyValue("VertOrient", (Object)graphicInfo.getVerticalAlignment());
            TextDocumentImage textDocumentImage = new TextDocumentImage(this.textDocument, xImage, graphicInfo);
            if (this.imageToImageIds == null) {
                this.imageToImageIds = new HashMap<ITextDocumentImage, String>();
            }
            this.imageToImageIds.put(textDocumentImage, tempId);
            return textDocumentImage;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextDocumentTextShape constructNewTextShape(TextInfo textInfo) throws TextException {
        try {
            if (this.xMultiServiceFactory == null) {
                throw new TextException("OpenOffice.org XMultiServiceFactory interface not valid.");
            }
            if (this.xTextShapeContainer == null) {
                this.xTextShapeContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.xMultiServiceFactory.createInstance("com.sun.star.drawing.MarkerTable"));
            }
            Object textShape = this.xMultiServiceFactory.createInstance("com.sun.star.text.TextFrame");
            XTextContent xTextShape = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)textShape);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextShape);
            String tempId = "tempTextShapeId" + System.currentTimeMillis();
            this.xTextShapeContainer.insertByName(tempId, (Object)textInfo.getName());
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xTextShape);
            xNamed.setName(textInfo.getName());
            xProps.setPropertyValue("AnchorType", (Object)textInfo.getAnchor());
            int minWidth = textInfo.getMinimumWidth();
            int minHeight = textInfo.getMinimumHeight();
            if (minWidth != -1) {
                xProps.setPropertyValue("Width", (Object)new Integer(minWidth));
            }
            if (minHeight != -1) {
                xProps.setPropertyValue("Height", (Object)new Integer(minHeight));
            }
            if (textInfo.isAutoWidth()) {
                xProps.setPropertyValue("WidthType", (Object)new Short(2));
            }
            if (textInfo.isAutoHeight()) {
                xProps.setPropertyValue("FrameIsAutomaticHeight", (Object)new Boolean(true));
                xProps.setPropertyValue("SizeType", (Object)2);
            } else {
                xProps.setPropertyValue("SizeType", (Object)1);
            }
            xProps.setPropertyValue("HoriOrient", (Object)textInfo.getHorizontalAlignment());
            xProps.setPropertyValue("VertOrient", (Object)textInfo.getVerticalAlignment());
            int backColor = textInfo.getBackColor();
            if (backColor != -1) {
                xProps.setPropertyValue("BackColor", (Object)new Integer(textInfo.getBackColor()));
                xProps.setPropertyValue("BackColorTransparency", (Object)new Short(0));
                xProps.setPropertyValue("BackTransparent", (Object)new Boolean(false));
            } else {
                xProps.setPropertyValue("BackColorTransparency", (Object)new Short(100));
                xProps.setPropertyValue("BackTransparent", (Object)new Boolean(true));
            }
            TextDocumentTextShape textDocumentTextShape = new TextDocumentTextShape(this.textDocument, xTextShape, textInfo);
            XText xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)textShape);
            textDocumentTextShape.setXText(xShapeText);
            if (this.textShapeToTextShapeIds == null) {
                this.textShapeToTextShapeIds = new HashMap<ITextDocumentTextShape, String>();
            }
            this.textShapeToTextShapeIds.put(textDocumentTextShape, tempId);
            return textDocumentTextShape;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextRange constructNewTextRange(IDocument doc, XTextRange xTextRange) throws TextException {
        try {
            TextRange range = new TextRange(doc, xTextRange);
            return range;
        }
        catch (Exception e) {
            TextException textException = new TextException(e.getMessage());
            textException.initCause(e);
            throw textException;
        }
    }

    @Override
    public void insertTextContent(ITextContent textContent) throws TextException {
        try {
            this.xText.insertTextContent(this.xText.getStart(), textContent.getXTextContent(), true);
            this.cleanupImage(textContent);
            this.cleanupTextShape(textContent);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void removeTextContent(ITextContent textContent) throws TextException {
        try {
            this.xText.removeTextContent(textContent.getXTextContent());
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void insertTextContent(ITextRange textRange, ITextContent textContent) throws TextException {
        try {
            if (textContent instanceof IParagraph) {
                IParagraph paragraph = (IParagraph)textContent;
                IParagraph[] oldParagraphsBeforeInsert = this.getRealParagraphs();
                Object object = this.xMultiServiceFactory.createInstance("com.sun.star.text.TextTable");
                XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object);
                xTable.initialize(1, 1);
                this.xText.insertTextContent(textRange.getXTextRange(), (XTextContent)xTable, false);
                XRelativeTextContentInsert xRelativeTextContentInsert = (XRelativeTextContentInsert)UnoRuntime.queryInterface(XRelativeTextContentInsert.class, (Object)this.xText);
                xRelativeTextContentInsert.insertTextContentAfter(paragraph.getXTextContent(), (XTextContent)xTable);
                this.xText.removeTextContent((XTextContent)xTable);
                paragraph.setXTextContent(this.getNewParagraphTextContent(oldParagraphsBeforeInsert));
            } else {
                XText xText = textRange.getXTextRange().getText();
                XTextRange targetRange = textRange.getXTextRange();
                XTextContent xTextContent = textContent.getXTextContent();
                xText.insertTextContent(targetRange, xTextContent, true);
                this.cleanupImage(textContent);
                this.cleanupTextShape(textContent);
            }
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void insertTextContentBefore(ITextContent newTextContent, ITextContent textContent) throws TextException {
        try {
            XRelativeTextContentInsert xRelativeTextContentInsert = (XRelativeTextContentInsert)UnoRuntime.queryInterface(XRelativeTextContentInsert.class, (Object)this.xText);
            IParagraph[] oldParagraphsBeforeInsert = this.getRealParagraphs();
            if (newTextContent instanceof ITextTable) {
                IParagraph paragraph = this.constructNewParagraph();
                xRelativeTextContentInsert.insertTextContentBefore(paragraph.getXTextContent(), textContent.getXTextContent());
                paragraph.setXTextContent(this.getNewParagraphTextContent(oldParagraphsBeforeInsert));
                this.xText.insertTextContent(paragraph.getXTextContent().getAnchor(), newTextContent.getXTextContent(), false);
                this.xText.removeTextContent(paragraph.getXTextContent());
            } else {
                xRelativeTextContentInsert.insertTextContentBefore(newTextContent.getXTextContent(), textContent.getXTextContent());
                if (newTextContent instanceof IParagraph) {
                    IParagraph paragraph = (IParagraph)newTextContent;
                    paragraph.setXTextContent(this.getNewParagraphTextContent(oldParagraphsBeforeInsert));
                }
                this.cleanupImage(textContent);
                this.cleanupTextShape(textContent);
            }
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void insertTextContentAfter(ITextContent newTextContent, ITextContent textContent) throws TextException {
        try {
            XRelativeTextContentInsert xRelativeTextContentInsert = (XRelativeTextContentInsert)UnoRuntime.queryInterface(XRelativeTextContentInsert.class, (Object)this.xText);
            IParagraph[] oldParagraphsBeforeInsert = this.getRealParagraphs();
            if (newTextContent instanceof ITextTable) {
                IParagraph paragraph = this.constructNewParagraph();
                XTextContent oldXTextContent = textContent.getXTextContent();
                xRelativeTextContentInsert.insertTextContentAfter(paragraph.getXTextContent(), oldXTextContent);
                paragraph.setXTextContent(this.getNewParagraphTextContent(oldParagraphsBeforeInsert));
                this.xText.insertTextContent(paragraph.getXTextContent().getAnchor(), newTextContent.getXTextContent(), false);
                this.xText.removeTextContent(paragraph.getXTextContent());
            } else if (newTextContent instanceof IParagraph) {
                if (textContent instanceof ITextTable) {
                    XTextContent newXTextContent = newTextContent.getXTextContent();
                    XTextContent oldXTextContent = textContent.getXTextContent();
                    xRelativeTextContentInsert.insertTextContentAfter(newXTextContent, oldXTextContent);
                } else {
                    Object object = this.xMultiServiceFactory.createInstance("com.sun.star.text.TextTable");
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object);
                    xTable.initialize(1, 1);
                    this.xText.insertTextContent(textContent.getXTextContent().getAnchor(), (XTextContent)xTable, false);
                    xRelativeTextContentInsert.insertTextContentAfter(newTextContent.getXTextContent(), (XTextContent)xTable);
                    this.xText.removeTextContent((XTextContent)xTable);
                }
                IParagraph paragraph = (IParagraph)newTextContent;
                paragraph.setXTextContent(this.getNewParagraphTextContent(oldParagraphsBeforeInsert));
            } else {
                XTextContent newContent = newTextContent.getXTextContent();
                XTextContent successor = textContent.getXTextContent();
                xRelativeTextContentInsert.insertTextContentAfter(newContent, successor);
                this.cleanupImage(textContent);
                this.cleanupTextShape(textContent);
            }
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void convertLinkedImagesToEmbeded() throws TextException {
        try {
            XTextGraphicObjectsSupplier graphicObjSupplier = (XTextGraphicObjectsSupplier)UnoRuntime.queryInterface(XTextGraphicObjectsSupplier.class, (Object)this.textDocument.getXTextDocument());
            XNameAccess nameAccess = graphicObjSupplier.getGraphicObjects();
            String[] names = nameAccess.getElementNames();
            for (int i = 0; i < names.length; ++i) {
                XMultiServiceFactory multiServiceFactory;
                XNameContainer xBitmapContainer;
                Any xImageAny = (Any)nameAccess.getByName(names[i]);
                Object xImageObject = xImageAny.getObject();
                XTextContent xImage = (XTextContent)xImageObject;
                XServiceInfo xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xImage);
                if (!xInfo.supportsService("com.sun.star.text.TextGraphicObject")) continue;
                XPropertySet xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xImage);
                String name = xPropSet.getPropertyValue("LinkDisplayName").toString();
                String graphicURL = xPropSet.getPropertyValue("GraphicURL").toString();
                if (graphicURL.indexOf("vnd.sun.") != -1 || (xBitmapContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)(multiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.textDocument.getXTextDocument())).createInstance("com.sun.star.drawing.BitmapTable"))).hasByName(name)) continue;
                xBitmapContainer.insertByName(name, (Object)graphicURL);
                String newGraphicURL = xBitmapContainer.getByName(name).toString();
                xPropSet.setPropertyValue("GraphicURL", (Object)newGraphicURL);
            }
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    private void cleanupImage(ITextContent textContent) throws NoSuchElementException, WrappedTargetException {
        if (textContent instanceof ITextDocumentImage && this.imageToImageIds != null && this.xBitmapContainer != null) {
            String id = this.imageToImageIds.get(textContent);
            if (id != null) {
                this.imageToImageIds.remove(textContent);
                this.xBitmapContainer.removeByName(id);
            }
            ((ITextDocumentImage)textContent).getGraphicInfo().cleanUp();
        }
    }

    private void cleanupTextShape(ITextContent textContent) throws NoSuchElementException, WrappedTargetException {
        String id;
        if (textContent instanceof ITextDocumentTextShape && this.textShapeToTextShapeIds != null && this.xTextShapeContainer != null && (id = this.textShapeToTextShapeIds.get(textContent)) != null) {
            this.textShapeToTextShapeIds.remove(textContent);
            this.xTextShapeContainer.removeByName(id);
        }
    }

    private XTextContent getNewParagraphTextContent(IParagraph[] oldParagraphsBeforeInsert) throws TextException {
        try {
            IParagraph[] newParagraphs = this.getRealParagraphs();
            for (int i = 0; i < newParagraphs.length; ++i) {
                IParagraph newParagraph = newParagraphs[i];
                IParagraph oldParagraph = null;
                if (i >= oldParagraphsBeforeInsert.length) {
                    return newParagraphs[newParagraphs.length - 1].getXTextContent();
                }
                oldParagraph = oldParagraphsBeforeInsert[i];
                XText text = newParagraph.getXTextContent().getAnchor().getText();
                text = this.textDocument.getTextService().getText().getXText();
                XTextRangeCompare comparator = (XTextRangeCompare)UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)text);
                if (comparator.compareRegionStarts(newParagraph.getXTextContent().getAnchor().getStart(), oldParagraph.getXTextContent().getAnchor().getStart()) == 0) continue;
                return newParagraph.getXTextContent();
            }
            return null;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    private IParagraph[] getRealParagraphs() throws Exception {
        XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)this.textDocument.getTextService().getText().getXText());
        XEnumeration xParagraphEnumeration = xEnumerationAccess.createEnumeration();
        ArrayList<Paragraph> realParagraphs = new ArrayList<Paragraph>();
        while (xParagraphEnumeration.hasMoreElements()) {
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xParagraphEnumeration.nextElement());
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xTextContent);
            if (!xServiceInfo.supportsService("com.sun.star.text.Paragraph")) continue;
            realParagraphs.add(new Paragraph(this.textDocument, xTextContent));
        }
        return realParagraphs.toArray(new IParagraph[realParagraphs.size()]);
    }
}

