/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.Annotation;
import ag.ion.bion.officelayer.text.IAnnotation;
import ag.ion.bion.officelayer.text.IAnnotationService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextField;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class AnnotationService
implements IAnnotationService {
    private ITextDocument textDocument = null;

    public AnnotationService(ITextDocument textDocument) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        this.textDocument = textDocument;
    }

    @Override
    public IAnnotation[] getAnnotations() {
        try {
            ITextField[] fields = this.textDocument.getTextFieldService().getUserTextFields();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (int i = 0; i < fields.length; ++i) {
                XServiceInfo info = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)fields[i].getXTextContent());
                if (!info.supportsService("com.sun.star.text.TextField.Annotation")) continue;
                annotations.add(new Annotation(this.textDocument, fields[i]));
            }
            return annotations.toArray(new IAnnotation[annotations.size()]);
        }
        catch (Exception exception) {
            return new IAnnotation[0];
        }
    }
}

