/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.form;

import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.form.IForm;
import ag.ion.bion.officelayer.form.IFormComponent;
import ag.ion.bion.officelayer.form.IFormService;
import ag.ion.bion.officelayer.internal.form.Form;
import ag.ion.bion.officelayer.internal.form.FormComponent;
import ag.ion.bion.officelayer.internal.form.Messages;
import ag.ion.noa.NOAException;
import com.sun.star.awt.XControlModel;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexContainer;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.form.XForm;
import com.sun.star.form.XFormComponent;
import com.sun.star.form.XFormsSupplier;
import com.sun.star.form.XFormsSupplier2;
import com.sun.star.script.XEventAttacherManager;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class FormService
implements IFormService {
    private IDocument document = null;
    private XDrawPage xDrawPage = null;

    public FormService(IDocument document, XDrawPage xDrawPage) throws IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException(Messages.getString("FormService.exception_document_invalid"));
        }
        this.document = document;
        if (xDrawPage == null) {
            throw new IllegalArgumentException(Messages.getString("FormService.exception_xdrawPage_interface_invalid"));
        }
        this.xDrawPage = xDrawPage;
    }

    @Override
    public IForm[] getForms(String formName) throws NOAException {
        try {
            XFormsSupplier formsSupplier;
            if (formName != null && (formsSupplier = (XFormsSupplier)UnoRuntime.queryInterface(XFormsSupplier.class, (Object)this.xDrawPage)) != null) {
                XNameContainer nameContainer = formsSupplier.getForms();
                XIndexContainer indexContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)nameContainer);
                int len = indexContainer.getCount();
                ArrayList<Form> forms = new ArrayList<Form>();
                for (int i = 0; i < len; ++i) {
                    XFormComponent tmpFormComponent;
                    XNamed tmpNamed;
                    Object tmpForm = indexContainer.getByIndex(i);
                    if (tmpForm == null || (tmpNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)tmpForm)) == null || !tmpNamed.getName().equalsIgnoreCase(formName) || (tmpFormComponent = (XFormComponent)UnoRuntime.queryInterface(XFormComponent.class, (Object)tmpForm)) == null) continue;
                    forms.add(new Form(this.document, null, tmpFormComponent));
                }
                return forms.toArray(new IForm[forms.size()]);
            }
            return new IForm[0];
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public XEventAttacherManager getXEventAttacherManager(IForm form) throws NOAException {
        try {
            XFormsSupplier formsSupplier;
            if (form != null && (formsSupplier = (XFormsSupplier)UnoRuntime.queryInterface(XFormsSupplier.class, (Object)this.xDrawPage)) != null) {
                XNameContainer nameContainer = formsSupplier.getForms();
                XIndexContainer indexContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)nameContainer);
                int len = indexContainer.getCount();
                for (int i = 0; i < len; ++i) {
                    XForm tmpForm = (XForm)UnoRuntime.queryInterface(XForm.class, (Object)indexContainer.getByIndex(i));
                    if (tmpForm == null || !UnoRuntime.areSame((Object)form.getXFormComponent(), (Object)tmpForm)) continue;
                    XEventAttacherManager tmpEventAttacherManager = (XEventAttacherManager)UnoRuntime.queryInterface(XEventAttacherManager.class, (Object)tmpForm);
                    return tmpEventAttacherManager;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public int getIndexInForm(IForm form, IFormComponent formComponent) throws NOAException {
        try {
            XFormsSupplier formsSupplier;
            if (form != null && formComponent != null && (formsSupplier = (XFormsSupplier)UnoRuntime.queryInterface(XFormsSupplier.class, (Object)this.xDrawPage)) != null) {
                XNameContainer nameContainer = formsSupplier.getForms();
                XIndexContainer indexContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)nameContainer);
                int len = indexContainer.getCount();
                for (int i = 0; i < len; ++i) {
                    XForm tmpForm = (XForm)UnoRuntime.queryInterface(XForm.class, (Object)indexContainer.getByIndex(i));
                    if (tmpForm == null || !UnoRuntime.areSame((Object)form.getXFormComponent(), (Object)tmpForm)) continue;
                    XIndexContainer container = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)tmpForm);
                    int lenFormPComponents = container.getCount();
                    for (int j = 0; j < lenFormPComponents; ++j) {
                        XFormComponent tmpFormComponent;
                        Object tmpObject = container.getByIndex(j);
                        if (tmpObject == null || (tmpFormComponent = (XFormComponent)UnoRuntime.queryInterface(XFormComponent.class, (Object)tmpObject)) == null || !UnoRuntime.areSame((Object)tmpFormComponent, (Object)formComponent.getXFormComponent())) continue;
                        return j;
                    }
                }
            }
            return -1;
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public boolean hasForms() throws NOAException {
        XFormsSupplier2 formsSupplier2 = (XFormsSupplier2)UnoRuntime.queryInterface(XFormsSupplier2.class, (Object)this.xDrawPage);
        if (formsSupplier2 != null) {
            return formsSupplier2.hasForms();
        }
        XFormsSupplier formsSupplier = (XFormsSupplier)UnoRuntime.queryInterface(XFormsSupplier.class, (Object)this.xDrawPage);
        if (formsSupplier != null) {
            return formsSupplier.getForms().hasElements();
        }
        return false;
    }

    @Override
    public boolean hasFormComponents() throws NOAException {
        try {
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)this.xDrawPage);
            if (xShapes != null) {
                int shapeCount = xShapes.getCount();
                for (int i = 0; i < shapeCount; ++i) {
                    XFormComponent xFormComponent;
                    XControlModel control;
                    XControlShape controlShape;
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)xShapes.getByIndex(i));
                    if (xShape == null || (controlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)xShape)) == null || (control = controlShape.getControl()) == null || (xFormComponent = (XFormComponent)UnoRuntime.queryInterface(XFormComponent.class, (Object)control)) == null) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
        return false;
    }

    @Override
    public IFormComponent[] getFormComponents() throws NOAException {
        try {
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)this.xDrawPage);
            if (xShapes != null) {
                int shapeCount = xShapes.getCount();
                ArrayList<FormComponent> formComponents = new ArrayList<FormComponent>();
                for (int i = 0; i < shapeCount; ++i) {
                    XFormComponent xFormComponent;
                    XControlModel controlModel;
                    XControlShape controlShape;
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)xShapes.getByIndex(i));
                    if (xShape == null || (controlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)xShape)) == null || (controlModel = controlShape.getControl()) == null || (xFormComponent = (XFormComponent)UnoRuntime.queryInterface(XFormComponent.class, (Object)controlModel)) == null) continue;
                    formComponents.add(new FormComponent(this.document, controlShape, xFormComponent));
                }
                return formComponents.toArray(new IFormComponent[formComponents.size()]);
            }
            return new IFormComponent[0];
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public String[] getFormComponentsNames() throws NOAException {
        try {
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)this.xDrawPage);
            if (xShapes != null) {
                int shapeCount = xShapes.getCount();
                ArrayList<Object> formComponentNames = new ArrayList<Object>();
                for (int i = 0; i < shapeCount; ++i) {
                    XPropertySet propertySet;
                    XFormComponent xFormComponent;
                    XControlModel control;
                    XControlShape controlShape;
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)xShapes.getByIndex(i));
                    if (xShape == null || (controlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)xShape)) == null || (control = controlShape.getControl()) == null || (xFormComponent = (XFormComponent)UnoRuntime.queryInterface(XFormComponent.class, (Object)control)) == null || (propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFormComponent)) == null || !propertySet.getPropertySetInfo().hasPropertyByName("Name")) continue;
                    formComponentNames.add(propertySet.getPropertyValue("Name"));
                }
                return formComponentNames.toArray(new String[formComponentNames.size()]);
            }
            return new String[0];
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public void removeFormComponent(IFormComponent formComponent) throws NOAException {
        if (formComponent != null) {
            this.xDrawPage.remove((XShape)formComponent.getXControlShape());
        }
    }
}

