/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.document;

import ag.ion.bion.officelayer.document.DocumentException;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IPersistenceService;
import ag.ion.bion.officelayer.filter.IFilter;
import ag.ion.bion.officelayer.filter.PDFFilter;
import ag.ion.bion.officelayer.internal.document.Messages;
import ag.ion.noa.ErrorCodeTranslator;
import ag.ion.noa.NOAException;
import ag.ion.noa.document.URLAdapter;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.lib.uno.adapter.OutputStreamToXOutputStreamAdapter;
import com.sun.star.task.ErrorCodeIOException;
import java.io.OutputStream;
import java.net.URL;

public class PersistenceService
implements IPersistenceService {
    private static final String ERROR_MESSAGE = Messages.getString("PersistenceService.general_error_message");
    private IDocument document = null;
    private XStorable xStorable = null;

    public PersistenceService(IDocument document, XStorable xStorable) throws IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException(Messages.getString("PersistenceService.exception_document_invalid"));
        }
        this.document = document;
        if (xStorable == null) {
            throw new IllegalArgumentException(Messages.getString("PersistenceService.exception_xstorable_interface_invalid"));
        }
        this.xStorable = xStorable;
    }

    @Override
    public boolean hasLocation() {
        return this.xStorable.hasLocation();
    }

    @Override
    public URL getLocation() {
        String documentURL = this.xStorable.getLocation();
        if (documentURL == null) {
            return null;
        }
        try {
            URL url = new URL(documentURL);
            return url;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.xStorable.isReadonly();
    }

    @Override
    public void store() throws DocumentException {
        try {
            this.xStorable.store();
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (throwable instanceof ErrorCodeIOException) {
                if (message == null || message.length() == 0) {
                    message = Messages.getString("PersistenceService.error_io_message", String.valueOf(((ErrorCodeIOException)throwable).ErrCode));
                }
            } else if (message == null || message.length() == 0) {
                message = ERROR_MESSAGE;
            }
            throw new DocumentException(message, throwable);
        }
    }

    @Override
    public void store(String url) throws DocumentException {
        if (url == null) {
            throw new DocumentException(Messages.getString("PersistenceService.error_url_invalid_message"));
        }
        try {
            boolean useFilter;
            url = URLAdapter.adaptURL(url);
            PropertyValue[] initialPropertyValues = this.document.getInitialProperties();
            String filterDefinition = null;
            for (int i = 0; i < initialPropertyValues.length; ++i) {
                if (!initialPropertyValues[i].Name.equalsIgnoreCase("FilterName")) continue;
                filterDefinition = initialPropertyValues[i].Value.toString();
            }
            boolean bl = useFilter = filterDefinition != null && filterDefinition.length() > 0;
            if (useFilter) {
                PropertyValue[] propertyValues = new PropertyValue[]{new PropertyValue()};
                propertyValues[0].Name = "FilterName";
                propertyValues[0].Value = filterDefinition;
                this.xStorable.storeAsURL(url, propertyValues);
            } else {
                this.xStorable.storeAsURL(url, new PropertyValue[0]);
            }
            this.document.setModified(false);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (throwable instanceof ErrorCodeIOException) {
                if (message == null || message.length() == 0) {
                    message = Messages.getString("PersistenceService.error_io_message", String.valueOf(((ErrorCodeIOException)throwable).ErrCode));
                }
            } else if (message == null || message.length() == 0) {
                message = ERROR_MESSAGE;
            }
            throw new DocumentException(message, throwable);
        }
    }

    @Override
    public void store(OutputStream outputStream) throws DocumentException {
        this.document.fireDocumentEvent("OnSave");
        try {
            this.storeInternal(outputStream);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (throwable instanceof ErrorCodeIOException) {
                if (message == null || message.length() == 0) {
                    message = Messages.getString("PersistenceService.error_io_message", String.valueOf(((ErrorCodeIOException)throwable).ErrCode));
                }
            } else if (message == null || message.length() == 0) {
                message = ERROR_MESSAGE;
            }
            throw new DocumentException(message, throwable);
        }
        this.document.fireDocumentEvent("OnSaveDone");
        this.document.fireDocumentEvent("OnSaveFinished");
    }

    @Override
    public void storeAs(OutputStream outputStream) throws NOAException {
        this.document.fireDocumentEvent("OnSaveAs");
        try {
            this.storeInternal(outputStream);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (throwable instanceof ErrorCodeIOException) {
                if (message == null || message.length() == 0) {
                    message = Messages.getString("PersistenceService.error_io_message", String.valueOf(((ErrorCodeIOException)throwable).ErrCode));
                }
            } else if (message == null || message.length() == 0) {
                message = ERROR_MESSAGE;
            }
            throw new NOAException(message, throwable);
        }
        this.document.fireDocumentEvent("OnSaveAsDone");
    }

    @Override
    public void export(String url, IFilter filter) throws DocumentException {
        PropertyValue[] properties;
        if (url == null) {
            throw new DocumentException(Messages.getString("PersistenceService.error_url_invalid_message"));
        }
        if (filter == null) {
            throw new DocumentException(Messages.getString("PersistenceService.error_filter_invalid_message"));
        }
        String filterDefinition = filter.getFilterDefinition(this.document);
        PropertyValue[] propertyValueArray = properties = filter instanceof PDFFilter ? new PropertyValue[2] : new PropertyValue[1];
        if (filterDefinition != null) {
            properties[0] = new PropertyValue();
            properties[0].Name = "FilterName";
            properties[0].Value = filterDefinition;
            if (filter instanceof PDFFilter) {
                properties[1] = new PropertyValue();
                properties[1].Name = "FilterData";
                properties[1].Value = ((PDFFilter)filter).getPDFFilterProperties().toPropertyValues();
            }
        }
        if (!filter.isExternalFilter()) {
            this.document.fireDocumentEvent("OnSaveAs");
        }
        try {
            url = URLAdapter.adaptURL(url);
            this.xStorable.storeToURL(url, properties);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (throwable instanceof ErrorCodeIOException) {
                message = ErrorCodeTranslator.getErrorCodeMessage(((ErrorCodeIOException)throwable).ErrCode);
                if (message == null) {
                    message = Messages.getString("PersistenceService.error_io_message", String.valueOf(((ErrorCodeIOException)throwable).ErrCode));
                }
            } else if (message == null || message.length() == 0) {
                message = ERROR_MESSAGE;
            }
            throw new DocumentException(message, throwable);
        }
        if (!filter.isExternalFilter()) {
            this.document.fireDocumentEvent("OnSaveAsDone");
        }
    }

    @Override
    public void export(OutputStream outputStream, IFilter filter) throws NOAException {
        if (outputStream == null) {
            throw new NOAException(Messages.getString("PersistenceService_error_message_invalid_output_stream"));
        }
        if (filter == null || !filter.isSupported(this.document)) {
            throw new NOAException(Messages.getString("PersistenceService.error_filter_invalid_message"));
        }
        String filterDefinition = filter.getFilterDefinition(this.document);
        OutputStreamToXOutputStreamAdapter streamAdapter = new OutputStreamToXOutputStreamAdapter(outputStream);
        PropertyValue[] properties = filter instanceof PDFFilter ? new PropertyValue[3] : new PropertyValue[2];
        properties[0] = new PropertyValue();
        properties[0].Name = "FilterName";
        properties[0].Value = filterDefinition;
        properties[1] = new PropertyValue("OutputStream", -1, (Object)streamAdapter, PropertyState.DIRECT_VALUE);
        if (filter instanceof PDFFilter) {
            properties[2] = new PropertyValue();
            properties[2].Name = "FilterData";
            properties[2].Value = ((PDFFilter)filter).getPDFFilterProperties().toPropertyValues();
        }
        if (!filter.isExternalFilter()) {
            this.document.fireDocumentEvent("OnSaveAs");
        }
        try {
            this.xStorable.storeToURL("private:stream", properties);
        }
        catch (Throwable throwable) {
            String message = throwable.getMessage();
            if (throwable instanceof ErrorCodeIOException) {
                message = ErrorCodeTranslator.getErrorCodeMessage(((ErrorCodeIOException)throwable).ErrCode);
                if (message == null) {
                    message = Messages.getString("PersistenceService.error_io_message", String.valueOf(((ErrorCodeIOException)throwable).ErrCode));
                }
            } else if (message == null || message.length() == 0) {
                message = ERROR_MESSAGE;
            }
            throw new NOAException(message, throwable);
        }
        if (!filter.isExternalFilter()) {
            this.document.fireDocumentEvent("OnSaveAsDone");
        }
    }

    private void storeInternal(OutputStream outputStream) throws Throwable {
        if (outputStream == null) {
            return;
        }
        OutputStreamToXOutputStreamAdapter stream = new OutputStreamToXOutputStreamAdapter(outputStream);
        PropertyValue[] initialPropertyValues = this.document.getInitialProperties();
        String filterDefinition = null;
        for (int i = 0; i < initialPropertyValues.length; ++i) {
            if (!initialPropertyValues[i].Name.equalsIgnoreCase("FilterName")) continue;
            filterDefinition = initialPropertyValues[i].Value.toString();
        }
        boolean useFilter = filterDefinition != null && filterDefinition.length() > 0;
        int propCount = 2;
        if (useFilter) {
            propCount = 3;
        }
        PropertyValue[] propertyValues = new PropertyValue[propCount];
        propertyValues[0] = new PropertyValue("OutputStream", -1, (Object)stream, PropertyState.DIRECT_VALUE);
        propertyValues[1] = new PropertyValue();
        propertyValues[1].Name = "Hidden";
        propertyValues[1].Value = new Boolean(true);
        if (useFilter) {
            propertyValues[2] = new PropertyValue();
            propertyValues[2].Name = "FilterName";
            propertyValues[2].Value = filterDefinition;
        }
        this.xStorable.storeToURL("private:stream", propertyValues);
        this.document.setModified(false);
    }
}

