/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.desktop;

import ag.ion.bion.officelayer.application.connection.IOfficeConnection;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.NOAException;
import ag.ion.noa.frame.IDispatch;
import ag.ion.noa.frame.IDispatchDelegate;
import ag.ion.noa.frame.ILayoutManager;
import ag.ion.noa.internal.frame.Dispatch;
import ag.ion.noa.internal.frame.DispatchWrapper;
import ag.ion.noa.internal.frame.LayoutManager;
import ag.ion.noa.service.IServiceProvider;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XDispatchProviderInterception;
import com.sun.star.frame.XDispatchProviderInterceptor;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XInterceptorInfo;
import com.sun.star.frame.XLayoutManager;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class Frame
implements IFrame {
    private XFrame xFrame = null;
    private IOfficeConnection officeConnection = null;
    private IServiceProvider serviceProvider = null;
    private DispatchProviderInterceptor dispatchProviderInterceptor = null;
    private Map delegatesMap = null;
    private TreeSet disabledCommandURLs = null;

    public Frame(XFrame xFrame, IOfficeConnection officeConnection) {
        Assert.isNotNull(xFrame, XFrame.class, this);
        Assert.isNotNull(officeConnection, IOfficeConnection.class, this);
        this.xFrame = xFrame;
        this.officeConnection = officeConnection;
    }

    public Frame(XFrame xFrame, IServiceProvider serviceProvider) {
        Assert.isNotNull(xFrame, XFrame.class, this);
        Assert.isNotNull(serviceProvider, IServiceProvider.class, this);
        this.xFrame = xFrame;
        this.serviceProvider = serviceProvider;
    }

    @Override
    public XFrame getXFrame() {
        return this.xFrame;
    }

    @Override
    public ILayoutManager getLayoutManager() throws NOAException {
        try {
            XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xFrame);
            Object object = propertySet.getPropertyValue("LayoutManager");
            XLayoutManager layoutManager = (XLayoutManager)UnoRuntime.queryInterface(XLayoutManager.class, (Object)object);
            if (layoutManager != null) {
                return new LayoutManager(layoutManager);
            }
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
        return null;
    }

    @Override
    public void disableDispatch(String commandURL) {
        if (commandURL == null) {
            return;
        }
        if (this.disabledCommandURLs == null) {
            this.disabledCommandURLs = new TreeSet();
        }
        this.disabledCommandURLs.add(commandURL);
    }

    @Override
    public void addDispatchDelegate(String commandURL, IDispatchDelegate dispatchDelegate) {
        if (commandURL == null || dispatchDelegate == null) {
            return;
        }
        if (this.delegatesMap == null) {
            this.delegatesMap = new HashMap(5);
        }
        this.delegatesMap.put(commandURL, dispatchDelegate);
    }

    @Override
    public void removeDispatchDelegate(String commandURL) {
        if (this.delegatesMap == null || commandURL == null) {
            return;
        }
        this.delegatesMap.remove(commandURL);
    }

    @Override
    public IDispatch getDispatch(String commandURL) throws NOAException {
        if (commandURL == null) {
            throw new NOAException("The command URL is not valid.");
        }
        try {
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)this.xFrame);
            URL[] urls = new URL[]{new URL()};
            urls[0].Complete = commandURL;
            Object service = null;
            service = this.officeConnection != null ? this.officeConnection.createService("com.sun.star.util.URLTransformer") : this.serviceProvider.createService("com.sun.star.util.URLTransformer");
            XURLTransformer xURLTranformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)service);
            xURLTranformer.parseStrict(urls);
            XDispatch xDispatch = xDispatchProvider.queryDispatch(urls[0], "", 55);
            if (xDispatch == null) {
                throw new NOAException("The command URL is not valid");
            }
            return new Dispatch(xDispatch, urls[0]);
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public void close() {
        this.xFrame.dispose();
    }

    @Override
    public void setFocus() {
        this.xFrame.getContainerWindow().setFocus();
        this.xFrame.activate();
    }

    @Override
    public void updateDispatches() {
        XDispatchProviderInterception xDispatchProviderInterception;
        if (this.dispatchProviderInterceptor != null && (xDispatchProviderInterception = (XDispatchProviderInterception)UnoRuntime.queryInterface(XDispatchProviderInterception.class, (Object)this.xFrame)) != null) {
            xDispatchProviderInterception.releaseDispatchProviderInterceptor((XDispatchProviderInterceptor)this.dispatchProviderInterceptor);
            this.dispatchProviderInterceptor = null;
        }
        if (this.dispatchProviderInterceptor == null && (xDispatchProviderInterception = (XDispatchProviderInterception)UnoRuntime.queryInterface(XDispatchProviderInterception.class, (Object)this.xFrame)) != null) {
            this.dispatchProviderInterceptor = new DispatchProviderInterceptor();
            xDispatchProviderInterception.registerDispatchProviderInterceptor((XDispatchProviderInterceptor)this.dispatchProviderInterceptor);
        }
    }

    @Override
    public void showPreview() throws NOAException {
        this.showPreview(1, 1);
    }

    @Override
    public void showPreview(int columns, int rows) throws NOAException {
        IDispatch dispatch = this.getDispatch(".uno:PrintPreview");
        dispatch.dispatch();
        if (columns < 1) {
            columns = 1;
        }
        if (rows < 1) {
            rows = 1;
        }
        dispatch = this.getDispatch(".uno:ShowMultiplePages");
        PropertyValue[] properties = new PropertyValue[2];
        properties[0] = new PropertyValue();
        properties[0].Name = "Columns";
        properties[0].Value = new Integer(columns);
        properties[1] = new PropertyValue();
        properties[1].Name = "Rows";
        properties[1].Value = new Integer(rows);
        dispatch.dispatch(properties);
    }

    private boolean isDispatchDisabled(String commandURL) {
        if (this.disabledCommandURLs == null) {
            return false;
        }
        return this.disabledCommandURLs.contains(commandURL);
    }

    private class DispatchProviderInterceptor
    implements XDispatchProviderInterceptor,
    XInterceptorInfo {
        private XDispatchProvider slaveDispatchProvider = null;
        private XDispatchProvider masterDispatchProvider = null;

        private DispatchProviderInterceptor() {
        }

        public XDispatchProvider getSlaveDispatchProvider() {
            return this.slaveDispatchProvider;
        }

        public void setSlaveDispatchProvider(XDispatchProvider slaveDispatchProvider) {
            this.slaveDispatchProvider = slaveDispatchProvider;
        }

        public XDispatchProvider getMasterDispatchProvider() {
            return this.masterDispatchProvider;
        }

        public void setMasterDispatchProvider(XDispatchProvider masterDispatchProvider) {
            this.masterDispatchProvider = masterDispatchProvider;
        }

        public XDispatch queryDispatch(URL url, String targetFrameName, int searchFlags) {
            String commandURL = url.Complete;
            if (Frame.this.isDispatchDisabled(commandURL)) {
                return null;
            }
            IDispatchDelegate dispatchDelegate = null;
            XDispatch xDispatch = null;
            if (Frame.this.delegatesMap != null) {
                dispatchDelegate = (IDispatchDelegate)Frame.this.delegatesMap.get(commandURL);
            }
            if (this.slaveDispatchProvider != null) {
                xDispatch = this.slaveDispatchProvider.queryDispatch(url, targetFrameName, searchFlags);
            }
            if (dispatchDelegate != null) {
                return new DispatchWrapper(dispatchDelegate, xDispatch);
            }
            return xDispatch;
        }

        public XDispatch[] queryDispatches(DispatchDescriptor[] dispatchDescriptors) {
            ArrayList<XDispatch> list = new ArrayList<XDispatch>();
            for (DispatchDescriptor dispatchDescriptor : dispatchDescriptors) {
                XDispatch dispatch = this.queryDispatch(dispatchDescriptor.FeatureURL, dispatchDescriptor.FrameName, dispatchDescriptor.SearchFlags);
                if (dispatch == null) continue;
                list.add(dispatch);
            }
            return list.toArray(new XDispatch[list.size()]);
        }

        public String[] getInterceptedURLs() {
            if (Frame.this.delegatesMap == null && Frame.this.disabledCommandURLs == null) {
                return new String[0];
            }
            String[] commandURLs = null;
            if (Frame.this.disabledCommandURLs != null) {
                commandURLs = Frame.this.disabledCommandURLs.toArray(new String[Frame.this.disabledCommandURLs.size()]);
            }
            if (Frame.this.delegatesMap != null) {
                if (commandURLs == null) {
                    commandURLs = Frame.this.delegatesMap.keySet().toArray(new String[Frame.this.delegatesMap.size()]);
                } else {
                    String[] temp = new String[commandURLs.length + Frame.this.delegatesMap.size()];
                    System.arraycopy(commandURLs, 0, temp, 0, commandURLs.length);
                    String[] newURLs = Frame.this.delegatesMap.keySet().toArray(new String[Frame.this.delegatesMap.size()]);
                    System.arraycopy(newURLs, 0, temp, commandURLs.length, newURLs.length);
                    commandURLs = temp;
                }
            }
            return commandURLs;
        }
    }
}

