/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application.connection;

import ag.ion.bion.officelayer.NativeView;
import ag.ion.bion.officelayer.application.connection.AbstractOfficeConnection;
import ag.ion.bion.officelayer.internal.application.connection.LocalOfficeConnectionGhost;
import ag.ion.bion.officelayer.internal.application.connection.Messages;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import com.sun.star.awt.XSystemChildFactory;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalOfficeConnection
extends AbstractOfficeConnection {
    private static Logger LOGGER = Logger.getLogger(LocalOfficeConnection.class.getName());
    private LocalOfficeConnectionGhost officeConnection = null;
    private String officePath = null;
    private String[] officeArguments = null;
    private String host = null;
    private String port = null;
    private boolean useBridge = false;

    public void setOfficePath(String officePath) {
        this.officePath = officePath;
    }

    public void setOfficeArguments(String[] arguments) {
        this.officeArguments = arguments;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUseBridge(boolean useBridge) {
        this.useBridge = useBridge;
    }

    public boolean usesBridge() {
        return this.useBridge;
    }

    @Override
    public boolean openConnection(IOfficeProgressMonitor officeProgressMonitor) throws Exception {
        LOGGER.info("Opening local OpenOffice.org connection.");
        System.out.println("LocalOfficeConnection: openConnection(officeProgressMonitor) begin");
        try {
            File file;
            if (officeProgressMonitor != null) {
                officeProgressMonitor.beginTask(Messages.getString("LocalOfficeConnection_monitor_office_application_message"), 5);
                officeProgressMonitor.worked(1);
            }
            if (this.officePath == null) {
                System.out.println("LocalOfficeConnection: (before) officePath==null");
            } else {
                System.out.println("LocalOfficeConnection: (before) officePath=" + this.officePath.toString());
            }
            if (this.officePath != null && !(file = new File(this.officePath)).canRead()) {
                throw new Exception("The home path of the office application does not exist.");
            }
            if (this.officePath != null) {
                System.setProperty("office.home", this.officePath);
            }
            if (this.officePath == null) {
                System.out.println("LocalOfficeConnection: (from office.home) officePath==null");
            } else {
                System.out.println("LocalOfficeConnection: (from office.home) officePath=" + this.officePath.toString());
            }
            if (officeProgressMonitor != null) {
                officeProgressMonitor.beginSubTask(Messages.getString("LocalOfficeConnection_monitor_loading_libraries_message"));
            }
            System.out.println("LocalOfficeConnection: trying new LocalOfficeConnectionGhost(officeProgressMonitor)...");
            this.officeConnection = new LocalOfficeConnectionGhost(officeProgressMonitor);
            if (this.officeConnection == null) {
                System.out.println("LocalOfficeConnection: officeConnection==null");
            } else {
                System.out.println("LocalOfficeConnection: officeConnection=" + this.officeConnection.toString());
            }
            if (this.officeArguments != null && this.officeArguments.length > 0) {
                this.officeConnection.setOfficeArguments(this.officeArguments);
            }
            if (officeProgressMonitor != null) {
                officeProgressMonitor.worked(1);
            }
            System.out.println("LocalOfficeConnection: officeConnection.getComponentContext()...");
            this.officeConnection.getComponentContext();
            if (officeProgressMonitor != null && officeProgressMonitor.needsDone()) {
                officeProgressMonitor.done();
            }
            System.out.println("LocalOfficeConnection: isConnected()=" + this.isConnected());
            System.out.println("LocalOfficeConnection: openConnection(officeProgressMonitor) about to return");
            return this.isConnected();
        }
        catch (Exception exception) {
            if (officeProgressMonitor != null && officeProgressMonitor.needsDone()) {
                officeProgressMonitor.done();
            }
            throw exception;
        }
    }

    @Override
    public boolean openConnection() throws Exception {
        return this.openConnection(null);
    }

    @Override
    public boolean isConnected() {
        if (this.officeConnection.getCurrentComponentContext() == null) {
            return false;
        }
        try {
            this.officeConnection.getCurrentComponentContext().getServiceManager();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void closeConnection() {
        try {
            this.officeConnection.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public XComponentContext getXComponentContext() {
        return this.officeConnection.getComponentContext();
    }

    @Override
    public XMultiServiceFactory getXMultiServiceFactory() throws Exception {
        return (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.getXMultiComponentFactory());
    }

    @Override
    public XMultiComponentFactory getXMultiComponentFactory() throws Exception {
        if (!this.isConnected()) {
            this.openConnection();
        }
        return this.officeConnection.getComponentContext().getServiceManager();
    }

    @Override
    public String getHost() {
        if (this.host == null) {
            return "localhost";
        }
        return this.host;
    }

    @Override
    public String getPort() {
        if (this.port == null) {
            return "local";
        }
        return this.port;
    }

    public OfficeWindow createLocalOfficeWindow(Container container) {
        return this.officeConnection.createOfficeWindow(container);
    }

    public XFrame getOfficeFrame(Container container) {
        if (this.officeConnection != null) {
            try {
                if (!this.isConnected()) {
                    this.openConnection();
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Creating local office window.");
                }
                NativeView nativeView = new NativeView(System.getProperty("user.dir") + "/lib");
                container.add(nativeView);
                return this.getOfficeFrame(nativeView);
            }
            catch (Exception exception) {
                LOGGER.throwing(this.getClass().getName(), "getOfficeFrame", exception);
                return null;
            }
        }
        return null;
    }

    public XFrame getOfficeFrame(NativeView nativeView) {
        if (this.officeConnection != null) {
            try {
                if (!this.isConnected()) {
                    this.openConnection();
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Creating local office window.");
                }
                XComponentContext xComponentContext = this.getXComponentContext();
                Object object = null;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Creating UNO XWindow interface.");
                }
                XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)this.getXMultiServiceFactory().createInstance("com.sun.star.awt.Toolkit"));
                XSystemChildFactory xChildFactory = (XSystemChildFactory)UnoRuntime.queryInterface(XSystemChildFactory.class, (Object)xToolkit);
                Integer handle = nativeView.getHWND();
                short systeme = (short)nativeView.getNativeWindowSystemType();
                byte[] procID = new byte[]{};
                XWindowPeer xWindowPeer = xChildFactory.createSystemChild((Object)handle, procID, systeme);
                XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xWindowPeer);
                object = this.getXMultiServiceFactory().createInstance("com.sun.star.frame.Task");
                if (object == null) {
                    object = this.getXMultiServiceFactory().createInstance("com.sun.star.frame.Frame");
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Creating UNO XFrame interface.");
                }
                XFrame xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object);
                xFrame.getContainerWindow();
                xFrame.initialize(xWindow);
                xFrame.setName(xFrame.toString());
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Creating desktop service.");
                }
                Object desktop = this.getXMultiServiceFactory().createInstance("com.sun.star.frame.Desktop");
                XFrames xFrames = ((XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)desktop)).getFrames();
                xFrames.append(xFrame);
                return xFrame;
            }
            catch (Exception exception) {
                LOGGER.throwing(this.getClass().getName(), "getOfficeFrame", exception);
                return null;
            }
        }
        return null;
    }
}

