/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.OSHelper;
import ag.ion.bion.officelayer.application.IApplicationAssistant;
import ag.ion.bion.officelayer.application.IApplicationProperties;
import ag.ion.bion.officelayer.application.ILazyApplicationInfo;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.internal.application.ApplicationProperties;
import ag.ion.bion.officelayer.internal.application.LazyLibreOfficeApplicationInfo;
import ag.ion.bion.officelayer.internal.application.LazyOpenOfficeOrgApplicationInfo;
import ag.ion.bion.officelayer.internal.application.Messages;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class ApplicationAssistant
implements IApplicationAssistant {
    private static final String KEY_MAIN_PART_OPEN_OFFICE_ORG = "OpenOffice.org";
    private static final String KEY_MAIN_PART_LIBRE_OFFICE = "LibreOffice";
    private static final String OPENOFFICE_ORG_OSX_APP = "OpenOffice.org.app";
    private static final String LIBREOFFICE_OSX_APP = "LibreOffice.app";
    private static final String PRE_PROGRAM_FOLDER_MAC = "Contents";
    private static final String PROGRAM_FOLDER = "program";
    private static final String RELATIVE_BOOTSTRAP = "program" + File.separator + "bootstrap";
    private static final String APPLICATION_EXECUTEABLE = "soffice";

    public ApplicationAssistant() throws OfficeApplicationException {
        this(null);
    }

    public ApplicationAssistant(String nativeLibPath) throws OfficeApplicationException {
        if (OSHelper.IS_WINDOWS) {
            try {
                String libPathFromProps = System.getProperty("noa.native.lib.path");
                if (libPathFromProps != null) {
                    nativeLibPath = libPathFromProps;
                }
                if (nativeLibPath != null) {
                    boolean is64Bit;
                    String libName = "ICE_JNIRegistry.dll";
                    String folder64bit = "64bit";
                    boolean bl = is64Bit = Integer.valueOf(System.getProperties().getProperty("sun.arch.data.model")) == 64;
                    if (is64Bit && new File(nativeLibPath + "/" + folder64bit + "/" + libName).exists()) {
                        nativeLibPath = nativeLibPath + "/" + folder64bit;
                    }
                    System.load(nativeLibPath + "\\" + libName);
                } else {
                    System.loadLibrary("ICE_JNIRegistry");
                }
            }
            catch (Throwable throwable) {
                throw new OfficeApplicationException(throwable);
            }
        }
    }

    @Override
    public ILazyApplicationInfo getLatestLocalOpenOfficeOrgApplication() {
        return this.getLatestLocalOpenOfficeOrgApplication(null);
    }

    @Override
    public ILazyApplicationInfo getLatestLocalOpenOfficeOrgApplication(IOfficeProgressMonitor officeProgressMonitor) {
        ILazyApplicationInfo[] lazyApplicationInfos = this.getLocalApplications(officeProgressMonitor);
        ILazyApplicationInfo latestLazyApplicationInfo = null;
        if (lazyApplicationInfos.length > 0) {
            for (int i = 0; i < lazyApplicationInfos.length; ++i) {
                ILazyApplicationInfo appInfo = lazyApplicationInfos[i];
                if (!(appInfo instanceof LazyOpenOfficeOrgApplicationInfo)) continue;
                if (latestLazyApplicationInfo == null) {
                    latestLazyApplicationInfo = appInfo;
                    continue;
                }
                if (appInfo.getMajorVersion() > latestLazyApplicationInfo.getMajorVersion()) {
                    latestLazyApplicationInfo = appInfo;
                    continue;
                }
                if (appInfo.getMajorVersion() == latestLazyApplicationInfo.getMajorVersion() && appInfo.getMinorVersion() > latestLazyApplicationInfo.getMinorVersion()) {
                    latestLazyApplicationInfo = appInfo;
                    continue;
                }
                if (appInfo.getMajorVersion() != latestLazyApplicationInfo.getMajorVersion() || appInfo.getMinorVersion() != latestLazyApplicationInfo.getMinorVersion() || appInfo.getUpdateVersion() <= latestLazyApplicationInfo.getUpdateVersion()) continue;
                latestLazyApplicationInfo = appInfo;
            }
        }
        return latestLazyApplicationInfo;
    }

    @Override
    public ILazyApplicationInfo getLatestLocalLibreOfficeApplication() {
        return this.getLatestLocalLibreOfficeApplication(null);
    }

    @Override
    public ILazyApplicationInfo getLatestLocalLibreOfficeApplication(IOfficeProgressMonitor officeProgressMonitor) {
        ILazyApplicationInfo[] lazyApplicationInfos = this.getLocalApplications(officeProgressMonitor);
        ILazyApplicationInfo latestLazyApplicationInfo = null;
        if (lazyApplicationInfos.length > 0) {
            for (int i = 0; i < lazyApplicationInfos.length; ++i) {
                ILazyApplicationInfo appInfo = lazyApplicationInfos[i];
                if (!(appInfo instanceof LazyLibreOfficeApplicationInfo)) continue;
                if (latestLazyApplicationInfo == null) {
                    latestLazyApplicationInfo = appInfo;
                    continue;
                }
                if (appInfo.getMajorVersion() > latestLazyApplicationInfo.getMajorVersion()) {
                    latestLazyApplicationInfo = appInfo;
                    continue;
                }
                if (appInfo.getMajorVersion() == latestLazyApplicationInfo.getMajorVersion() && appInfo.getMinorVersion() > latestLazyApplicationInfo.getMinorVersion()) {
                    latestLazyApplicationInfo = appInfo;
                    continue;
                }
                if (appInfo.getMajorVersion() != latestLazyApplicationInfo.getMajorVersion() || appInfo.getMinorVersion() != latestLazyApplicationInfo.getMinorVersion() || appInfo.getUpdateVersion() <= latestLazyApplicationInfo.getUpdateVersion()) continue;
                latestLazyApplicationInfo = appInfo;
            }
        }
        return latestLazyApplicationInfo;
    }

    @Override
    public ILazyApplicationInfo getLatestLocalApplication() {
        return this.getLatestLocalOpenOfficeOrgApplication();
    }

    @Override
    public ILazyApplicationInfo getLatestLocalApplication(IOfficeProgressMonitor officeProgressMonitor) {
        return this.getLatestLocalOpenOfficeOrgApplication(officeProgressMonitor);
    }

    @Override
    public ILazyApplicationInfo[] getLocalApplications() {
        return this.getLocalApplications(null);
    }

    @Override
    public ILazyApplicationInfo[] getLocalApplications(IOfficeProgressMonitor officeProgressMonitor) {
        ArrayList<ILazyApplicationInfo> arrayList = new ArrayList<ILazyApplicationInfo>();
        if (System.getProperty("oo.application.path") != null) {
            String path = new File(System.getProperty("oo.application.path")).getAbsolutePath();
            ILazyApplicationInfo applicationInfo = this.findLocalApplicationInfo(path);
            if (applicationInfo != null) {
                arrayList.add(applicationInfo);
            }
        } else if (OSHelper.IS_WINDOWS) {
            try {
                String[] possibleOpenOfficeOrgKeys = this.getPossibleKeys(KEY_MAIN_PART_OPEN_OFFICE_ORG);
                String[] possibleLibreOfficeKeys = this.getPossibleKeys(KEY_MAIN_PART_LIBRE_OFFICE);
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(Arrays.asList(possibleOpenOfficeOrgKeys));
                keys.addAll(Arrays.asList(possibleLibreOfficeKeys));
                String[] possibleKeys = keys.toArray(new String[keys.size()]);
                if (officeProgressMonitor != null) {
                    officeProgressMonitor.beginTask(Messages.getString("ApplicationAssistant.monitor_message_scannig_registry"), possibleKeys.length);
                }
                RegistryKey[] ROOTS = new RegistryKey[]{Registry.HKEY_CLASSES_ROOT, Registry.HKEY_CURRENT_USER, Registry.HKEY_LOCAL_MACHINE};
                int n = possibleKeys.length;
                for (int i = 0; i < n; ++i) {
                    if (officeProgressMonitor != null) {
                        officeProgressMonitor.beginSubTask(Messages.getString("ApplicationAssistant.monitor_scanning_key", possibleKeys[i]));
                    }
                    for (int j = 0; j < ROOTS.length; ++j) {
                        ILazyApplicationInfo applicationInfo;
                        int position;
                        RegistryKey registryKey = Registry.openSubkey((RegistryKey)ROOTS[j], (String)possibleKeys[i], (int)1);
                        if (registryKey == null) continue;
                        String path = null;
                        if (path == null) {
                            try {
                                path = registryKey.getStringValue("Path");
                                path = "\"" + path + "\"";
                            }
                            catch (NoSuchValueException noSuchValueException) {
                                // empty catch block
                            }
                        }
                        if (path == null) {
                            try {
                                path = registryKey.getDefaultValue();
                            }
                            catch (NoSuchValueException noSuchValueException) {
                                // empty catch block
                            }
                        }
                        if (path == null || (position = path.indexOf(APPLICATION_EXECUTEABLE)) == -1 || (applicationInfo = this.findLocalApplicationInfo(path = path.substring(1, position - 9))) == null) continue;
                        boolean found = false;
                        for (ILazyApplicationInfo tmpApplicationInfo : arrayList) {
                            if (!tmpApplicationInfo.getHome().equalsIgnoreCase(applicationInfo.getHome())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        arrayList.add(applicationInfo);
                    }
                    if (officeProgressMonitor != null && officeProgressMonitor.isCanceled()) break;
                }
            }
            catch (Throwable throwable) {
                return ILazyApplicationInfo.EMPTY_LAZY_APPLICATION_INFOS_ARRAY;
            }
        } else {
            try {
                if (officeProgressMonitor != null) {
                    officeProgressMonitor.beginTask(Messages.getString("ApplicationAssistant.monitor_looking_for_office_application"), -1);
                }
                ArrayList possibleOfficeHomes = new ArrayList();
                if (OSHelper.IS_MAC) {
                    File libreStandardFolder;
                    File appsFolder = new File("/Applications");
                    File oooStandardFolder = new File(appsFolder, OPENOFFICE_ORG_OSX_APP);
                    File folderToSearch = oooStandardFolder;
                    if (!folderToSearch.exists()) {
                        folderToSearch = appsFolder;
                    }
                    this.findPossibleOfficeHomes(officeProgressMonitor, folderToSearch, possibleOfficeHomes, 1, -1);
                    folderToSearch = libreStandardFolder = new File(appsFolder, LIBREOFFICE_OSX_APP);
                    if (!folderToSearch.exists()) {
                        folderToSearch = appsFolder;
                    }
                    this.findPossibleOfficeHomes(officeProgressMonitor, folderToSearch, possibleOfficeHomes, 1, -1);
                } else {
                    File file = new File("/opt");
                    this.findPossibleOfficeHomes(officeProgressMonitor, file, possibleOfficeHomes, 1, 2);
                    file = new File("/usr");
                    this.findPossibleOfficeHomes(officeProgressMonitor, file, possibleOfficeHomes, 1, 2);
                }
                if (officeProgressMonitor != null) {
                    officeProgressMonitor.beginSubTask(Messages.getString("ApplicationAssistant.monitor_buildung_application_infos"));
                }
                String[] officeHomes = possibleOfficeHomes.toArray(new String[possibleOfficeHomes.size()]);
                int n = officeHomes.length;
                for (int i = 0; i < n; ++i) {
                    ILazyApplicationInfo applicationInfo = this.findLocalApplicationInfo(officeHomes[i]);
                    if (applicationInfo == null) continue;
                    arrayList.add(applicationInfo);
                }
            }
            catch (Throwable throwable) {
                return ILazyApplicationInfo.EMPTY_LAZY_APPLICATION_INFOS_ARRAY;
            }
        }
        if (officeProgressMonitor != null && officeProgressMonitor.needsDone()) {
            officeProgressMonitor.done();
        }
        return arrayList.toArray(new ILazyApplicationInfo[arrayList.size()]);
    }

    @Override
    public ILazyApplicationInfo findLocalApplicationInfo(String home) {
        if (home == null) {
            return null;
        }
        File file = null;
        file = OSHelper.IS_WINDOWS ? new File(home + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".exe") : (OSHelper.IS_MAC ? new File(home + File.separator + PRE_PROGRAM_FOLDER_MAC + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".bin") : new File(home + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".bin"));
        if (file.canRead()) {
            if (home.toLowerCase().indexOf("libre") > -1) {
                return new LazyLibreOfficeApplicationInfo(home, this.findApplicationProperties(home));
            }
            return new LazyOpenOfficeOrgApplicationInfo(home, this.findApplicationProperties(home));
        }
        if (!OSHelper.IS_WINDOWS && (file = new File(home + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".sh")).canRead()) {
            if (home.toLowerCase().indexOf("libre") > -1) {
                return new LazyLibreOfficeApplicationInfo(home, this.findApplicationProperties(home));
            }
            return new LazyOpenOfficeOrgApplicationInfo(home, this.findApplicationProperties(home));
        }
        return null;
    }

    private void findPossibleOfficeHomes(IOfficeProgressMonitor officeProgressMonitor, File root, List list, int currentLevel, int maxLevel) {
        File[] files;
        if (root == null) {
            return;
        }
        if (root.isDirectory() && officeProgressMonitor != null) {
            officeProgressMonitor.beginSubTask(Messages.getString("ApplicationAssistant.monitor_scanning_directory", root.getName()));
        }
        if ((files = root.listFiles()) != null) {
            int n = files.length;
            for (int i = 0; !(i >= n || officeProgressMonitor != null && officeProgressMonitor.isCanceled()); ++i) {
                File parent;
                File file = files[i];
                if (file == null) continue;
                String fileName = file.getName();
                boolean homePathIdentified = false;
                if (!OSHelper.IS_WINDOWS) {
                    if (fileName.equals("soffice.bin") || fileName.equals("soffice.sh")) {
                        homePathIdentified = true;
                    }
                } else if (fileName.equals("soffice.exe")) {
                    homePathIdentified = true;
                }
                if (homePathIdentified && (parent = file.getParentFile()) != null) {
                    parent = parent.getParentFile();
                    if (OSHelper.IS_MAC) {
                        parent = parent.getParentFile();
                    }
                    if (parent != null) {
                        list.add(parent.getAbsolutePath());
                    }
                }
                if (!file.isDirectory()) continue;
                File progDir = new File(file, PROGRAM_FOLDER);
                boolean progDirExists = progDir.exists();
                if (progDirExists) {
                    this.findPossibleOfficeHomes(officeProgressMonitor, progDir, list, 1, 1);
                    continue;
                }
                if (currentLevel >= maxLevel && maxLevel != -1) continue;
                this.findPossibleOfficeHomes(officeProgressMonitor, file, list, currentLevel + 1, maxLevel);
            }
        }
    }

    private IApplicationProperties findApplicationProperties(String home) {
        File file = null;
        file = OSHelper.IS_WINDOWS ? new File(home + File.separator + RELATIVE_BOOTSTRAP + ".ini") : (OSHelper.IS_MAC ? new File(home + File.separator + PRE_PROGRAM_FOLDER_MAC + File.separator + RELATIVE_BOOTSTRAP + "rc") : new File(home + File.separator + RELATIVE_BOOTSTRAP + "rc"));
        if (file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                return new ApplicationProperties(properties);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    private String[] getPossibleKeys(String keyMainPart) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int minorVersion = 0;
        int updateVersion = 0;
        for (int majorVersion = 1; majorVersion <= 4; ++majorVersion) {
            arrayList.add("Applications\\" + keyMainPart + " " + majorVersion + "." + minorVersion + "\\shell\\edit\\command");
            arrayList.add("Applications\\" + keyMainPart + " " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
            arrayList.add("Software\\" + keyMainPart + "\\" + keyMainPart + "\\" + majorVersion + "." + minorVersion);
            arrayList.add("Software\\" + keyMainPart + "\\" + keyMainPart + "\\" + majorVersion + "." + minorVersion + "." + updateVersion);
            for (updateVersion = 1; updateVersion <= 150; ++updateVersion) {
                if (updateVersion >= 10 && updateVersion <= 80) continue;
                arrayList.add("Applications\\" + keyMainPart + " " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
                arrayList.add("Software\\" + keyMainPart + "\\" + keyMainPart + "\\" + majorVersion + "." + minorVersion + "." + updateVersion);
            }
            updateVersion = 1;
            for (minorVersion = 1; minorVersion <= 10; ++minorVersion) {
                arrayList.add("Applications\\" + keyMainPart + " " + majorVersion + "." + minorVersion + "\\shell\\edit\\command");
                arrayList.add("Applications\\" + keyMainPart + " " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
                arrayList.add("Software\\" + keyMainPart + "\\" + keyMainPart + "\\" + majorVersion + "." + minorVersion);
                arrayList.add("Software\\" + keyMainPart + "\\" + keyMainPart + "\\" + majorVersion + "." + minorVersion + "." + updateVersion);
                for (updateVersion = 2; updateVersion <= 150; ++updateVersion) {
                    if (updateVersion >= 10 && updateVersion <= 80) continue;
                    arrayList.add("Applications\\" + keyMainPart + " " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
                    arrayList.add("Software\\" + keyMainPart + "\\" + keyMainPart + "\\" + majorVersion + "." + minorVersion + "." + updateVersion);
                }
                updateVersion = 1;
            }
            minorVersion = 0;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

