/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.application.connection;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.application.OfficeApplicationRuntime;
import ag.ion.bion.officelayer.desktop.IDesktopService;
import ag.ion.bion.officelayer.document.IDocumentService;
import ag.ion.noa.NOAException;
import com.sun.star.auth.InvalidArgumentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleConnection {
    public static final int TYPE_LOCAL = 0;
    public static final int TYPE_REMOTE = 1;
    private IOfficeApplication officeAplication;
    private int type = -1;
    private IDocumentService documentService;
    private IDesktopService desktopService;
    private static SimpleConnection Connection;

    public static synchronized SimpleConnection getConnection() {
        Properties props = System.getProperties();
        if (props.containsKey("OFFICE_HOST")) {
            if (Connection == null) {
                try {
                    Connection = new SimpleConnection(props.getProperty("OFFICE_HOST"), Integer.valueOf(props.getProperty("OFFICE_PORT")));
                }
                catch (Exception ex) {
                    Logger.getLogger(SimpleConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return Connection;
        }
        throw new UnsupportedOperationException("OpenOffice is not configured yet.");
    }

    public SimpleConnection(String connectionString, int port) throws Exception {
        if (connectionString != null && connectionString.length() > 1 && port <= 0) {
            this.createLocalConnection(connectionString);
        } else if (connectionString != null && connectionString.length() > 1 && port > 0 && port < 9999) {
            this.createServerConnection(connectionString, port);
        } else {
            throw new Exception("Connection not possible with the given parameters: [" + connectionString + ":" + port + "]");
        }
    }

    private synchronized boolean createServerConnection(String host, int port) throws OfficeApplicationException, NOAException, InvalidArgumentException {
        if (host != null && port > 0) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("type", "remote");
            configuration.put("host", host.replace("http://", ""));
            configuration.put("port", String.valueOf(port));
            this.officeAplication = OfficeApplicationRuntime.getApplication(configuration);
            this.officeAplication.setConfiguration(configuration);
            try {
                this.officeAplication.activate();
            }
            catch (Exception officeApplicationException) {
                try {
                    Thread.sleep(6666L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                try {
                    this.officeAplication.activate();
                }
                catch (OfficeApplicationException officeApplicationException1) {
                    Logger.getLogger(SimpleConnection.class.getName()).log(Level.SEVERE, null, officeApplicationException1);
                }
            }
        } else {
            throw new InvalidArgumentException("Host cannot be null and port must be > 0: " + host + ":" + port);
        }
        this.documentService = this.officeAplication.getDocumentService();
        this.desktopService = this.officeAplication.getDesktopService();
        this.setType(1);
        return true;
    }

    private synchronized boolean createLocalConnection(String OOOPath) throws OfficeApplicationException, NOAException, InvalidArgumentException {
        if (OOOPath == null) {
            throw new InvalidArgumentException("Path to OO cannot be null: " + OOOPath);
        }
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("home", OOOPath);
        configuration.put("type", "local");
        this.officeAplication = OfficeApplicationRuntime.getApplication(configuration);
        this.officeAplication.setConfiguration(configuration);
        this.officeAplication.activate();
        this.documentService = this.officeAplication.getDocumentService();
        this.desktopService = this.officeAplication.getDesktopService();
        this.setType(0);
        return true;
    }

    public synchronized int getType() {
        return this.type;
    }

    private synchronized void setType(int type) {
        this.type = type;
    }

    public synchronized IDocumentService getDocumentService() {
        return this.documentService;
    }

    public synchronized IDesktopService getDesktopService() {
        return this.desktopService;
    }

    public static synchronized void startOOServerIfNotRunning(String path, int port) {
        Properties props = System.getProperties();
        String command = path.replace("\\", "\\\\") + File.separator + props.getProperty("OFFICE_BINARY_FOLDER") + File.separator + "soffice" + " " + "-headless" + " " + "-nofirststartwizard" + " " + "-norestore" + " " + "-nolockcheck" + " " + "-nocrashreport" + " " + "-nodefault" + " " + "-accept='socket,host=0.0.0.0,port=" + port + ";urp;StarOffice.Service'";
        try {
            InetSocketAddress addr = new InetSocketAddress("127.0.0.1", port);
            Socket socket = new Socket();
            socket.connect(addr, 100);
            throw new UnsupportedOperationException("Port " + port + " is already in use :-/. Not going to start OO here.");
        }
        catch (IOException iOException) {
            final ProcessBuilder builder = new ProcessBuilder(command);
            Map<String, String> environment = builder.environment();
            environment.put("path", ";");
            environment.put("path", path.replace("\\", "\\\\") + File.pathSeparator);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        Process oos = builder.start();
                        InputStream is = oos.getErrorStream();
                        InputStreamReader isr = new InputStreamReader(is);
                        BufferedReader br = new BufferedReader(isr);
                        while ((line = br.readLine()) != null) {
                            Logger.getLogger(SimpleConnection.class.getName()).log(Level.INFO, null, line);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SimpleConnection.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            new Thread(runnable).start();
            return;
        }
    }
}

